/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.variant;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class ShapeType<T extends LivingEntity> {
    private static final List<EntityType<? extends LivingEntity>> LIVING_TYPE_CASH = new ArrayList<EntityType<? extends LivingEntity>>();
    private final EntityType<T> type;
    private final int variantData;

    public static <Z extends LivingEntity> int getDefaultVariantData(EntityType<Z> type) {
        TypeProvider<Z> provider = TypeProviderRegistry.getProvider(type);
        if (provider != null) {
            return provider.getFallbackData();
        }
        return -1;
    }

    public ShapeType(EntityType<T> type) {
        this(type, ShapeType.getDefaultVariantData(type));
    }

    public ShapeType(EntityType<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public ShapeType(T entity) {
        this.type = entity.m_6095_();
        @Nullable TypeProvider<T> provider = TypeProviderRegistry.getProvider(this.type);
        this.variantData = provider != null ? provider.getVariantData(entity) : ShapeType.getDefaultVariantData(this.type);
    }

    @NotNull
    public static <Z extends LivingEntity> ShapeType<Z> from(EntityType<Z> entityType) {
        return new ShapeType<Z>(entityType, ShapeType.getDefaultVariantData(entityType));
    }

    @Nullable
    public static <Z extends LivingEntity> ShapeType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }
        return new ShapeType<Z>(entity);
    }

    @Nullable
    public static ShapeType<?> from(CompoundTag compound) {
        ResourceLocation id = Identifier.parse((String)compound.m_128461_("EntityID"));
        if (!Walkers.getEntityTypeRegistry().m_7804_(id)) {
            return null;
        }
        return ShapeType.from((EntityType)Walkers.getEntityTypeRegistry().m_7745_(id), compound.m_128441_("Variant") ? compound.m_128451_("Variant") : -1);
    }

    @Nullable
    public static <Z extends LivingEntity> ShapeType<Z> from(EntityType<Z> entityType, int variant) {
        TypeProvider<Z> typeProvider = TypeProviderRegistry.getProvider(entityType);
        if (typeProvider != null && (variant < -1 || variant > typeProvider.getRange())) {
            return null;
        }
        return new ShapeType<Z>(entityType, variant);
    }

    public static <T extends LivingEntity> List<ShapeType<T>> getAllTypes(EntityType<T> entityType) {
        ArrayList<ShapeType<T>> types = new ArrayList<ShapeType<T>>();
        if (!EntityBlacklist.isBlacklisted(entityType)) {
            TypeProvider<T> variant = TypeProviderRegistry.getProvider(entityType);
            if (variant != null) {
                for (int i = 0; i <= variant.getRange(); ++i) {
                    types.add(new ShapeType<T>(entityType, i));
                }
            } else {
                types.add(ShapeType.from(entityType));
            }
        }
        return types;
    }

    public static List<ShapeType<?>> getAllTypes(Level world) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (EntityType type : Walkers.getEntityTypeRegistry()) {
                try {
                    Entity instance = type.m_20615_(world);
                    if (!(instance instanceof LivingEntity)) continue;
                    LIVING_TYPE_CASH.add((EntityType<? extends LivingEntity>)type);
                }
                catch (Exception e) {
                    Walkers.LOGGER.error("{}: Caught an exception while getting shape types for entity type + {}: {}", new Object[]{ShapeType.class.getSimpleName(), type.m_147048_(), e});
                }
            }
        }
        ArrayList types = new ArrayList();
        for (EntityType<? extends LivingEntity> type : LIVING_TYPE_CASH) {
            types.addAll(ShapeType.getAllTypes(type));
        }
        return types;
    }

    public CompoundTag writeCompound() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("EntityID", EntityType.m_20613_(this.type).toString());
        compound.m_128405_("Variant", this.variantData);
        return compound;
    }

    public EntityType<? extends LivingEntity> getEntityType() {
        return this.type;
    }

    public T create(Level world) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(this.type);
        if (typeProvider != null) {
            return typeProvider.create(this.type, world, this.variantData);
        }
        return (T)((LivingEntity)this.type.m_20615_(world));
    }

    public T create(Level world, Player player) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(this.type);
        if (typeProvider != null) {
            return typeProvider.create(this.type, world, this.variantData, player);
        }
        return (T)((LivingEntity)this.type.m_20615_(world));
    }

    public int getVariantData() {
        return this.variantData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeType that = (ShapeType)o;
        return this.variantData == that.variantData && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantData);
    }

    public static <L extends LivingEntity> Component createTooltipText(L entity) {
        TypeProvider<L> provider = TypeProviderRegistry.getProvider(entity.m_6095_());
        if (provider != null) {
            return provider.modifyText(entity, TComponent.translatable((String)entity.m_6095_().m_20675_(), (Object[])new Object[0]));
        }
        return TComponent.translatable((String)entity.m_6095_().m_20675_(), (Object[])new Object[0]);
    }
}

