/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.integrations.impl;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.PreyTrait;

public class AlexMobsIntegration
extends AbstractIntegration {
    public static final String MODID = "alexsmobs";

    @Override
    public void registerTraits() {
        this.registerAlexMobsTargetTagTrait("anaconda", 1, 200);
        this.registerAlexMobsTargetTagTrait("bald_eagle", 4, 55);
        this.registerAlexMobsTargetTagTrait("cachalot_whale", 2, 30);
        this.registerAlexMobsTargetTagTrait("crimson-mosquito", 2, 50);
        this.registerAlexMobsTargetTagTrait("crocodile", 5, 180);
        TraitRegistry.registerByType(AlexMobsIntegration.getType("fly"), new PreyTrait(List.of(), List.of(), List.of(), List.of(AlexMobsIntegration.getTag("fly_hurt_targets")), 3, 5));
        this.registerAlexMobsTargetTagTrait("froststalker", 3, 80);
        this.registerAlexMobsTargetTagTrait("giant-squid", 3, 70);
        this.registerAlexMobsTargetTagTrait("komodo-dragon", 8, 180);
        this.registerAlexMobsTargetTagTrait("mantis_shrimp", 3, 120);
        this.registerAlexMobsTargetTagTrait("orca", 3, 200);
        this.registerAlexMobsTargetTagTrait("snow_leopard", 2, 10);
        this.registerAlexMobsTargetTagTrait("sunbird_scorch", 3, 5);
        this.registerAlexMobsTargetTagTrait("tiger", 4, 220);
        this.registerAlexMobsTargetTagTrait("warped_toad", 4, 50);
        TraitRegistry.registerByPredicate(entity -> entity instanceof Enemy && !(entity instanceof Creeper) && (!entity.m_6095_().m_20674_().name().contains("water") || !entity.m_20072_()) && !entity.m_6095_().m_204039_(AlexMobsIntegration.getTag("bunfungus_ignores")), new PreyTrait(List.of(), List.of(AlexMobsIntegration.getType("bunfungus")), List.of(), List.of(), 3, 5));
        this.registerAlexMobsFearTagTrait("mimic_octopus");
        this.registerAlexMobsFearTagTrait("skunk");
    }

    private void registerAlexMobsTargetTagTrait(String entityId, int priority, int randInt) {
        TraitRegistry.registerByTag(AlexMobsIntegration.getTag(entityId + "_targets"), new PreyTrait(List.of(), List.of(AlexMobsIntegration.getType(entityId)), List.of(), List.of(), priority, randInt));
    }

    private void registerAlexMobsFearTagTrait(String entityId) {
        TraitRegistry.registerByTag(AlexMobsIntegration.getTag(entityId + "_fears"), FearedTrait.ofFearfulType(AlexMobsIntegration.getType(entityId)));
    }

    private static EntityType<Mob> getType(String entityId) {
        return (EntityType)Walkers.getEntityTypeRegistry().m_7745_(Identifier.parse((String)MODID, (String)entityId));
    }

    private static TagKey<EntityType<?>> getTag(String tagId) {
        return TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)Identifier.parse((String)MODID, (String)tagId));
    }
}

