/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.mixin.TrackTargetGoalMixin;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;

@Mixin(value={NearestAttackableTargetGoal.class})
public abstract class ActiveTargetGoalMixin
extends TrackTargetGoalMixin {
    @Shadow
    protected LivingEntity f_26050_;

    @Inject(method={"start"}, at={@At(value="HEAD")}, cancellable=true)
    private void ignoreShapedPlayers(CallbackInfo ci) {
        boolean hasHostility;
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity;
        if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && this.f_26135_ instanceof Enemy && (livingEntity = this.f_26050_) instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null && Integrations.mightAttackInnocent(this.f_26135_, player) && !(hasHostility = PlayerHostility.hasHostility(player))) {
            for (FearedTrait fearedTrait : TraitRegistry.get(shape, FearedTrait.ID).stream().map(entry -> (FearedTrait)entry).toList()) {
                if (!fearedTrait.isFeared((LivingEntity)this.f_26135_)) continue;
                this.m_8041_();
                ci.cancel();
            }
            if (this.f_26135_ instanceof PolarBear && shape.m_6095_().equals(EntityType.f_20514_)) {
                this.m_8041_();
                ci.cancel();
            } else if (this.f_26135_ instanceof WitherBoss && shape.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER)) {
                this.m_8041_();
                ci.cancel();
            } else if (!(this.f_26135_ instanceof WitherBoss) && (shape instanceof Enemy || Walkers.CONFIG.hostilesIgnoreNotHostileShapedPlayer)) {
                if (this.f_26135_ instanceof EnderMan && shape.m_6095_().equals(EntityType.f_20567_)) {
                    return;
                }
                if (this.f_26135_ instanceof WitherSkeleton && shape instanceof AbstractPiglin) {
                    return;
                }
                this.m_8041_();
                ci.cancel();
            }
        }
    }

    @Override
    protected void shape_shouldContinue(CallbackInfoReturnable<Boolean> cir) {
        boolean hasHostility;
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity;
        if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && Walkers.CONFIG.hostilesForgetNewShapedPlayer && this.f_26135_ instanceof Enemy && (livingEntity = this.f_26050_) instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null && Integrations.mightAttackInnocent(this.f_26135_, player) && !(hasHostility = PlayerHostility.hasHostility(player))) {
            for (FearedTrait fearedTrait : TraitRegistry.get(shape, FearedTrait.ID).stream().map(entry -> (FearedTrait)entry).toList()) {
                if (!fearedTrait.isFeared((LivingEntity)this.f_26135_)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
            if (this.f_26135_ instanceof WitherBoss && shape.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER)) {
                cir.setReturnValue((Object)false);
            } else if (!(this.f_26135_ instanceof WitherBoss) && (shape instanceof Enemy || Walkers.CONFIG.hostilesIgnoreNotHostileShapedPlayer)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"canUse"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanUse(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (livingEntity = this.f_26050_) instanceof Player && PlayerShape.getCurrentShape(player = (Player)livingEntity) instanceof PolarBear) {
            cir.setReturnValue((Object)false);
        }
    }
}

