/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.impl.DimensionsRefresher;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"respawn"}, at={@At(value="RETURN")})
    private void onRespawn(ServerPlayer player, boolean alive, CallbackInfoReturnable<ServerPlayer> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        ((DimensionsRefresher)player).shape_refreshDimensions();
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth) {
                player.m_21051_(Attributes.f_22276_).m_22100_((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.m_21233_()));
                player.m_21153_(player.m_21233_());
            }
            if (Walkers.CONFIG.scalingAmor) {
                player.m_21051_(Attributes.f_22284_).m_22100_(Math.min((double)Walkers.CONFIG.maxAmor, shape.m_21172_(Attributes.f_22284_)));
                player.m_21051_(Attributes.f_22285_).m_22100_(Math.min((double)Walkers.CONFIG.maxAmor, shape.m_21172_(Attributes.f_22285_)));
            }
            if (Walkers.CONFIG.scalingHealth || Walkers.CONFIG.percentScalingHealth || Walkers.CONFIG.scalingAmor) {
                player.f_8906_.m_9829_((Packet)new ClientboundUpdateAttributesPacket(player.m_19879_(), player.m_21204_().m_22170_()));
            }
        }
        PlayerShapeChanger.sync(player);
        PlayerShape.sync(player);
    }
}

