/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;

@Mixin(value={VillagerHostilesSensor.class})
public class VillagerHostilesSensorMixin {
    @Shadow
    @Final
    private static ImmutableMap<EntityType<?>, Float> f_26842_;

    @Inject(method={"isHostile"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkHostileWalkers(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof Player) {
            LivingEntity shape;
            Player player = (Player)entity;
            if (Walkers.CONFIG.villagersRunFrom2ndShapes && (shape = PlayerShape.getCurrentShape(player)) != null && f_26842_.containsKey((Object)shape.m_6095_())) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isClose"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkPlayerDanger(LivingEntity villager, LivingEntity potentialPlayer, CallbackInfoReturnable<Boolean> cir) {
        if (potentialPlayer instanceof Player) {
            Player player = (Player)potentialPlayer;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null && f_26842_.containsKey((Object)shape.m_6095_())) {
                float f = ((Float)f_26842_.get((Object)shape.m_6095_())).floatValue();
                cir.setReturnValue((Object)(potentialPlayer.m_20280_((Entity)villager) <= (double)(f * f) ? 1 : 0));
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

