/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.RiderTrait;

@Mixin(value={Player.class})
public abstract class PlayerEntityDataMixin
extends LivingEntity
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    @Nullable
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    @Nullable
    private LivingEntity walkers$shape = null;
    @Unique
    private float walkers$normalHealth = -1.0f;

    private PlayerEntityDataMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        CompoundTag unlockedShape = tag.m_128469_("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);
        this.walkers$abilityCooldown = tag.m_128451_(ABILITY_COOLDOWN_KEY);
        this.walkers$remainingTime = tag.m_128451_("RemainingHostilityTime");
        this.walkers$normalHealth = tag.m_128457_("walkersHealth");
        this.walkers$readCurrentShape(tag.m_128469_("CurrentShape"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        CompoundTag id = new CompoundTag();
        if (this.walkers$unlocked != null) {
            id = this.walkers$unlocked.writeCompound();
        }
        tag.m_128365_("UnlockedShape", (Tag)id);
        tag.m_128405_(ABILITY_COOLDOWN_KEY, this.walkers$abilityCooldown);
        tag.m_128405_("RemainingHostilityTime", this.walkers$remainingTime);
        tag.m_128350_("walkersHealth", this.walkers$normalHealth);
        tag.m_128365_("CurrentShape", (Tag)this.walkers$writeCurrentShape(new CompoundTag()));
    }

    @Unique
    private CompoundTag walkers$writeCurrentShape(CompoundTag tag) {
        CompoundTag entityTag = new CompoundTag();
        if (this.walkers$shape != null) {
            this.walkers$shape.m_20240_(entityTag);
        }
        tag.m_128359_("id", this.walkers$shape == null ? "minecraft:empty" : EntityType.m_20613_((EntityType)this.walkers$shape.m_6095_()).toString());
        tag.m_128365_("EntityData", (Tag)entityTag);
        return tag;
    }

    @Unique
    public void walkers$readCurrentShape(CompoundTag tag) {
        CompoundTag entityTag;
        Optional type = EntityType.m_20637_((CompoundTag)tag);
        if (tag.m_128461_("id").equals("minecraft:empty")) {
            this.walkers$shape = null;
            ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
        } else if (type.isPresent() && !(entityTag = tag.m_128469_("EntityData")).m_128456_()) {
            if (this.walkers$shape == null || !((EntityType)type.get()).equals(this.walkers$shape.m_6095_())) {
                this.walkers$shape = (LivingEntity)((EntityType)type.get()).m_20615_(CEntity.level((Entity)this));
                ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
            }
            this.walkers$shape.m_20258_(entityTag);
        }
    }

    @Override
    @Unique
    @Nullable
    public ShapeType<?> walkers$get2ndShape() {
        return this.walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Override
    @Unique
    public int walkers$getRemainingHostilityTime() {
        return this.walkers$remainingTime;
    }

    @Override
    @Unique
    public void walkers$setRemainingHostilityTime(int max) {
        this.walkers$remainingTime = max;
    }

    @Override
    @Unique
    public int walkers$getAbilityCooldown() {
        return this.walkers$abilityCooldown;
    }

    @Override
    @Unique
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    @Nullable
    public LivingEntity walkers$getCurrentShape() {
        return this.walkers$shape;
    }

    @Override
    @Unique
    public void walkers$setCurrentShape(LivingEntity shape) {
        this.walkers$shape = shape;
    }

    @Override
    @Unique
    public void walkers$updateShapes(@Nullable LivingEntity shape) {
        float currentHealthPercent;
        Player player = (Player)this;
        AttributeInstance healthAttribute = player.m_21051_(Attributes.f_22276_);
        AttributeInstance armorAttribute = player.m_21051_(Attributes.f_22284_);
        AttributeInstance armorToughnessAttribute = player.m_21051_(Attributes.f_22285_);
        this.walkers$shape = shape;
        ((DimensionsRefresher)player).shape_refreshDimensions();
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                this.walkers$normalHealth = player.m_21233_();
                currentHealthPercent = player.m_21223_() / player.m_21233_();
                healthAttribute.m_22100_((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.m_21233_()));
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.m_21153_(Math.min(currentHealthPercent * player.m_21233_(), player.m_21233_()));
                } else {
                    player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                AttributeInstance shapeArmorAttribute = shape.m_21051_(Attributes.f_22284_);
                if (armorAttribute != null && shapeArmorAttribute != null) {
                    armorAttribute.m_22100_(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorAttribute.m_22115_()));
                }
                AttributeInstance shapeArmorToughnessAttribute = shape.m_21051_(Attributes.f_22285_);
                if (armorToughnessAttribute != null && shapeArmorToughnessAttribute != null) {
                    armorToughnessAttribute.m_22100_(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorToughnessAttribute.m_22115_()));
                }
            }
        }
        if (shape == null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                currentHealthPercent = player.m_21223_() / player.m_21233_();
                float health = Walkers.CONFIG.player_health;
                if (health < 0.0f) {
                    health = this.walkers$normalHealth > 0.0f ? this.walkers$normalHealth : 20.0f;
                }
                healthAttribute.m_22100_((double)health);
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.m_21153_(Math.min(currentHealthPercent * player.m_21233_(), player.m_21233_()));
                } else {
                    player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                if (armorAttribute != null) {
                    armorAttribute.m_22100_(0.0);
                }
                if (armorToughnessAttribute != null) {
                    armorAttribute.m_22100_(0.0);
                }
            }
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (Walkers.hasFlyingPermissions((ServerPlayer)player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            FlightHelper.updateFlyingSpeed(player);
            player.m_6885_();
        } else if (!player.m_7500_()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.m_150110_().m_35943_(0.05f);
            player.m_6885_();
        }
        Entity entity = player.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity;
            boolean b1 = false;
            boolean b2 = false;
            for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                Player rideablePlayer;
                if (riderTrait.isRideable(livingVehicle) || livingVehicle instanceof Player && riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (Player)livingVehicle))) {
                    b1 = true;
                    b2 = true;
                }
                if (!b2) continue;
                break;
            }
            if (!b1) {
                player.m_8127_();
            }
        }
        if (!(shape instanceof AbstractHorse)) {
            for (Entity passenger : player.m_20197_()) {
                passenger.m_8127_();
            }
        }
        if (!CEntity.level((Entity)player).f_46443_) {
            PlayerShape.sync((ServerPlayer)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)CEntity.level((Entity)player)).m_7726_().f_8325_).getEntityMap();
            Object tracking = trackers.get(player.m_19879_());
            ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((ServerPlayer)player, listener.m_142253_()));
        }
    }
}

