/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.specific.GrassEaterAbility;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.DolphinAccessor;
import tocraft.walkers.mixin.accessor.PufferfishAccessor;
import tocraft.walkers.mixin.accessor.SheepAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.MobEffectTrait;

@Mixin(value={Player.class})
public abstract class PlayerEntityTickMixin
extends LivingEntity {
    @Unique
    private static Predicate<BlockState> walkers$IS_TALL_GRASS = null;

    private PlayerEntityTickMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        WalkersTickHandler<?> handler;
        @Nullable LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null && (handler = WalkersTickHandlers.getHandlers().get(shape.m_6095_())) != null) {
            handler.tick((Player)this, shape);
        }
        if (!CEntity.level((Entity)this).f_46443_) {
            PlayerDataProvider data = (PlayerDataProvider)((Object)this);
            data.walkers$setRemainingHostilityTime(Math.max(0, data.walkers$getRemainingHostilityTime() - 1));
            ServerPlayer player = (ServerPlayer)this;
            PlayerAbilities.setCooldown((Player)player, Math.max(0, data.walkers$getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void setShapeData(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof ShapeDataProvider) {
            ShapeDataProvider shapeData = (ShapeDataProvider)shape;
            shapeData.walkers$ShapedPlayer(this.m_19879_());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pufferfishServerTick(CallbackInfo info) {
        LivingEntity shape;
        if (!CEntity.level((Entity)this).f_46443_ && this.m_6084_() && (shape = PlayerShape.getCurrentShape((Player)this)) instanceof Pufferfish) {
            Pufferfish pufferfishShape = (Pufferfish)shape;
            if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 0) {
                if (pufferfishShape.m_29631_() == 0) {
                    this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
                    pufferfishShape.m_29618_(1);
                } else if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 40 && pufferfishShape.m_29631_() == 1) {
                    this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
                    pufferfishShape.m_29618_(2);
                }
                ((PufferfishAccessor)pufferfishShape).setInflateCounter(((PufferfishAccessor)pufferfishShape).getInflateCounter() + 1);
            } else if (pufferfishShape.m_29631_() != 0) {
                if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 60 && pufferfishShape.m_29631_() == 2) {
                    this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
                    pufferfishShape.m_29618_(1);
                } else if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 100 && pufferfishShape.m_29631_() == 1) {
                    this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
                    pufferfishShape.m_29618_(0);
                }
                ((PufferfishAccessor)pufferfishShape).setDeflateTimer(((PufferfishAccessor)pufferfishShape).getDeflateTimer() + 1);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void dolphinServerTick(CallbackInfo info) {
        Player nearestPlayer;
        Player player;
        LivingEntity shape;
        if (!CEntity.level((Entity)this).f_46443_ && this.m_6084_() && (shape = PlayerShape.getCurrentShape(player = (Player)this)) instanceof Dolphin && (nearestPlayer = CEntity.level((Entity)player).m_45946_(DolphinAccessor.getSWIM_WITH_PLAYER_TARGETING(), (LivingEntity)player)) != null && nearestPlayer.m_6069_()) {
            nearestPlayer.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 100), (Entity)player);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyMobEffectTrait(CallbackInfo info) {
        Player player;
        LivingEntity shape;
        if (!CEntity.level((Entity)this).f_46443_ && this.m_6084_() && TraitRegistry.has(shape = PlayerShape.getCurrentShape(player = (Player)this), MobEffectTrait.ID)) {
            List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
            block5: for (MobEffectTrait mobEffectTrait : traitList) {
                MobEffectInstance mobEffectInstance = mobEffectTrait.mobEffectInstance;
                if (mobEffectTrait.showInInventory && mobEffectTrait.applyToSelf) {
                    player.m_147207_(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_(), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)player);
                }
                switch (mobEffectTrait.applyToNearby) {
                    case 0: {
                        List nearbyPlayers = CEntity.level((Entity)player).m_45955_(TargetingConditions.m_148353_().m_26883_((double)mobEffectTrait.maxDistanceForEntities).m_148355_(), (LivingEntity)player, player.m_20191_().m_82377_((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyPlayers.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyPlayers.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Player)nearbyPlayers.get(i)).m_147207_(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_(), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)player);
                        }
                        continue block5;
                    }
                    case 1: {
                        List nearbyMobs = CEntity.level((Entity)player).m_45971_(Mob.class, TargetingConditions.m_148353_().m_26883_((double)mobEffectTrait.maxDistanceForEntities).m_148355_(), (LivingEntity)player, player.m_20191_().m_82377_((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyMobs.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyMobs.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Mob)nearbyMobs.get(i)).m_147207_(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_(), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)player);
                        }
                        continue block5;
                    }
                    case 2: {
                        List nearbyMobs = CEntity.level((Entity)player).m_45971_(Mob.class, TargetingConditions.m_148353_().m_26883_((double)mobEffectTrait.maxDistanceForEntities).m_148355_(), (LivingEntity)player, player.m_20191_().m_82377_((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        List nearbyPlayers = CEntity.level((Entity)player).m_45955_(TargetingConditions.m_148353_().m_26883_((double)mobEffectTrait.maxDistanceForEntities).m_148355_(), (LivingEntity)player, player.m_20191_().m_82377_((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        ArrayList nearbyEntites = new ArrayList();
                        nearbyEntites.addAll(nearbyMobs);
                        nearbyEntites.addAll(nearbyPlayers);
                        nearbyEntites.sort((first, second) -> Float.compare(player.m_20270_((Entity)first), player.m_20270_((Entity)second)));
                        if (nearbyEntites.isEmpty()) break;
                        for (int i = 0; i < nearbyEntites.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Mob)nearbyMobs.get(i)).m_147207_(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_(), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_(), mobEffectInstance.m_19575_()), (Entity)player);
                        }
                        break;
                    }
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void sheepServerTick(CallbackInfo info) {
        ShapeAbility<LivingEntity> shapeAbility;
        ServerPlayer serverPlayer;
        LivingEntity shape;
        if (walkers$IS_TALL_GRASS == null) {
            walkers$IS_TALL_GRASS = BlockStatePredicate.m_61287_((Block)((Block)CEntity.level((Entity)this).m_9598_().m_175515_(CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).m_123023_()).m_7745_(Identifier.parse((String)"grass"))));
        }
        if (!CEntity.level((Entity)this).f_46443_ && this.m_6084_() && (shape = PlayerShape.getCurrentShape((Player)(serverPlayer = (ServerPlayer)this))) != null && (shapeAbility = AbilityRegistry.get(shape)) instanceof GrassEaterAbility) {
            GrassEaterAbility grassEaterAbility = (GrassEaterAbility)shapeAbility;
            if (grassEaterAbility.eatTick.get(serverPlayer.m_20148_()) != null && grassEaterAbility.eatTick.get(serverPlayer.m_20148_()) != 0) {
                grassEaterAbility.eatTick.put(serverPlayer.m_20148_(), Math.max(0, grassEaterAbility.eatTick.get(serverPlayer.m_20148_()) - 1));
                if (shape instanceof Sheep) {
                    Sheep sheepShape = (Sheep)shape;
                    ((SheepAccessor)sheepShape).setEatAnimationTick(grassEaterAbility.eatTick.get(serverPlayer.m_20148_()));
                }
                if (grassEaterAbility.eatTick.get(serverPlayer.m_20148_()) == Mth.m_184652_((int)4, (int)2)) {
                    BlockPos blockPos = serverPlayer.m_20183_();
                    if (walkers$IS_TALL_GRASS.test(CEntity.level((Entity)this).m_8055_(blockPos)) && this.walkers$isLookingAtPos(blockPos)) {
                        CEntity.level((Entity)this).m_46961_(blockPos, false);
                        this.m_146850_(GameEvent.f_157806_);
                        serverPlayer.m_36324_().m_38707_(3, 0.2f);
                        if (shape instanceof Sheep) {
                            Sheep sheepShape = (Sheep)shape;
                            sheepShape.m_29878_(false);
                        }
                    } else {
                        BlockPos blockPos2 = blockPos.m_7495_();
                        if (CEntity.level((Entity)this).m_8055_(blockPos2).m_60713_(Blocks.f_50440_) && this.walkers$isLookingAtPos(blockPos2)) {
                            CEntity.level((Entity)this).m_46796_(2001, blockPos2, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                            CEntity.level((Entity)this).m_7731_(blockPos2, Blocks.f_50493_.m_49966_(), 2);
                            this.m_146850_(GameEvent.f_157806_);
                            serverPlayer.m_36324_().m_38707_(3, 0.1f);
                            if (shape instanceof Sheep) {
                                Sheep sheepShape = (Sheep)shape;
                                sheepShape.m_29878_(false);
                            }
                        }
                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isLookingAtPos(BlockPos blockPos) {
        BlockHitResult blockHitResult;
        Player player = (Player)this;
        HitResult hitResult = player.m_19907_(2.0, 0.0f, false);
        return hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).m_82425_().equals((Object)blockPos);
    }
}

