/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class PreyTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("prey");
    public static final MapCodec<PreyTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("hunter", new ArrayList()).forGetter(o -> o.hunterTypes.stream().map(arg_0 -> Walkers.getEntityTypeRegistry().m_7981_(arg_0)).toList()), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("hunter_tags", new ArrayList()).forGetter(o -> o.hunterTags.stream().map(TagKey::f_203868_).toList())).apply((Applicative)instance, instance.stable((hunterLocations, hunterTagLocations) -> {
        ArrayList hunterTypes = new ArrayList();
        ArrayList hunterTags = new ArrayList();
        for (ResourceLocation resourceLocation : hunterLocations) {
            if (!Walkers.getEntityTypeRegistry().m_7804_(resourceLocation)) continue;
            hunterTypes.add((EntityType)Walkers.getEntityTypeRegistry().m_7745_(resourceLocation));
        }
        for (ResourceLocation hunterTagLocation : hunterTagLocations) {
            hunterTags.add(TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)hunterTagLocation));
        }
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), hunterTypes, new ArrayList<Class<? extends LivingEntity>>(), hunterTags);
    })));
    private final List<Predicate<LivingEntity>> hunterPredicates;
    private final List<EntityType<?>> hunterTypes;
    private final List<Class<? extends LivingEntity>> hunterClasses;
    private final List<TagKey<EntityType<?>>> hunterTags;
    private final int priority;
    private final int randInt;

    public static PreyTrait<?> ofHunterType(EntityType<?> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), List.of(hunter), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterTag(TagKey<EntityType<?>> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), List.of(hunter));
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterClass(Class<? extends LivingEntity> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), List.of(hunter), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates) {
        this(hunterPredicates, new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates, @NotNull List<EntityType<?>> hunterTypes, @NotNull List<Class<? extends LivingEntity>> hunterClasses, @NotNull List<TagKey<EntityType<?>>> hunterTags) {
        this(hunterPredicates, hunterTypes, hunterClasses, hunterTags, 7, 10);
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates, @NotNull List<EntityType<?>> hunterTypes, @NotNull List<Class<? extends LivingEntity>> hunterClasses, @NotNull List<TagKey<EntityType<?>>> hunterTags, int priority, int randInt) {
        this.hunterPredicates = hunterPredicates;
        this.hunterTypes = hunterTypes;
        this.hunterClasses = hunterClasses;
        this.hunterTags = hunterTags;
        this.priority = priority;
        this.randInt = randInt;
    }

    public boolean isHunter(LivingEntity entity) {
        if (this.hunterTypes.contains(entity.m_6095_())) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : this.hunterClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (TagKey tagKey : this.hunterTags) {
            if (!entity.m_6095_().m_204039_(tagKey)) continue;
            return true;
        }
        for (Predicate predicate : this.hunterPredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getRandInt() {
        return this.randInt;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

