/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class RiderTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("rider");
    public static final MapCodec<RiderTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("rideable", new ArrayList()).forGetter(o -> o.rideableTypes.stream().map(arg_0 -> Walkers.getEntityTypeRegistry().m_7981_(arg_0)).toList()), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("rideable_tags", new ArrayList()).forGetter(o -> o.rideableTags.stream().map(TagKey::f_203868_).toList())).apply((Applicative)instance, instance.stable((rideableTypeIds, rideableTagIds) -> {
        ArrayList rideableTypes = new ArrayList();
        ArrayList rideableTags = new ArrayList();
        for (ResourceLocation rideableTypeId : rideableTypeIds) {
            if (!Walkers.getEntityTypeRegistry().m_7804_(rideableTypeId)) continue;
            rideableTypes.add((EntityType)Walkers.getEntityTypeRegistry().m_7745_(rideableTypeId));
        }
        for (ResourceLocation rideableTagId : rideableTagIds) {
            rideableTags.add(TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)rideableTagId));
        }
        return new RiderTrait(new ArrayList<Predicate<LivingEntity>>(), rideableTypes, new ArrayList<Class<? extends LivingEntity>>(), rideableTags);
    })));
    private final List<Predicate<LivingEntity>> rideablePredicates;
    private final List<EntityType<?>> rideableTypes;
    private final List<Class<? extends LivingEntity>> rideableClasses;
    private final List<TagKey<EntityType<?>>> rideableTags;

    public static RiderTrait<?> ofRideableType(EntityType<?> ... rideable) {
        return new RiderTrait(Stream.of(rideable).map(entry -> entity -> entity.m_6095_().equals(entry)).toList());
    }

    @SafeVarargs
    public static RiderTrait<?> ofRideableClass(Class<? extends LivingEntity> ... rideable) {
        return new RiderTrait(Stream.of(rideable).map(entry -> entry::isInstance).toList());
    }

    public RiderTrait(@NotNull List<Predicate<LivingEntity>> rideablePredicates) {
        this(rideablePredicates, new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    public RiderTrait(@NotNull List<Predicate<LivingEntity>> rideablePredicates, @NotNull List<EntityType<?>> rideableTypes, @NotNull List<Class<? extends LivingEntity>> rideableClasses, @NotNull List<TagKey<EntityType<?>>> rideableTags) {
        this.rideablePredicates = rideablePredicates;
        this.rideableTypes = rideableTypes;
        this.rideableClasses = rideableClasses;
        this.rideableTags = rideableTags;
    }

    public boolean isRideable(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (this.rideableTypes.contains(entity.m_6095_())) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : this.rideableClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (TagKey tagKey : this.rideableTags) {
            if (!entity.m_6095_().m_204039_(tagKey)) continue;
            return true;
        }
        for (Predicate predicate : this.rideablePredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

