/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers;

import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.VIPs;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.api.data.DataManager;
import tocraft.walkers.api.platform.WalkersConfig;
import tocraft.walkers.command.WalkersCommand;
import tocraft.walkers.eventhandler.LivingBreatheHandler;
import tocraft.walkers.eventhandler.RespawnHandler;
import tocraft.walkers.eventhandler.WalkersEventHandlers;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.network.ServerNetworking;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FlyingTrait;

public class Walkers {
    public static final Logger LOGGER = LoggerFactory.getLogger(Walkers.class);
    public static final String MODID = "walkers";
    public static final WalkersConfig CONFIG = (WalkersConfig)ConfigLoader.register((String)"walkers", (Config[])new WalkersConfig[0]);
    public static final List<UUID> devs = new ArrayList<UUID>();

    public void initialize() {
        Integrations.initIntegrations();
        TraitRegistry.initialize();
        AbilityRegistry.initialize();
        WalkersCommand.initialize();
        WalkersEventHandlers.initialize();
        ServerNetworking.initialize();
        Walkers.registerJoinSyncPacket();
        WalkersTickHandlers.initialize();
        DataManager.initialize();
        Integrations.initialize();
        PlayerEvents.PLAYER_RESPAWN.register((Object)new RespawnHandler());
        EntityEvents.LIVING_BREATHE.register((Object)new LivingBreatheHandler());
    }

    public static void registerJoinSyncPacket() {
        VersionChecker.registerModrinthChecker((String)MODID, (String)"woodwalkers", (Component)TComponent.literal((String)"Woodwalkers"));
        PlayerEvents.PLAYER_JOIN.register(player -> {
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)CEntity.level((Entity)player)).m_7726_().f_8325_).getEntityMap();
            trackers.forEach((entityid, tracking) -> {
                if (CEntity.level((Entity)player).m_6815_(entityid.intValue()) instanceof ServerPlayer) {
                    PlayerShape.sync((ServerPlayer)CEntity.level((Entity)player).m_6815_(entityid.intValue()), player);
                }
            });
        });
    }

    public static ResourceLocation id(String name) {
        return Identifier.parse((String)MODID, (String)name);
    }

    public static boolean hasFlyingPermissions(ServerPlayer player) {
        if (player.m_7500_()) {
            return true;
        }
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && Walkers.CONFIG.enableFlight && (TraitRegistry.has(shape, FlyingTrait.ID) || shape instanceof FlyingMob)) {
            List<String> requiredAdvancements = Walkers.CONFIG.advancementsRequiredForFlight;
            if (!requiredAdvancements.isEmpty()) {
                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    AdvancementProgress progress;
                    Advancement advancement = player.f_8924_.m_129889_().m_136041_(Identifier.parse((String)requiredAdvancement));
                    if (advancement == null || (progress = player.m_8960_().m_135996_(advancement)).m_8193_()) continue;
                    hasPermission = false;
                }
                return hasPermission;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlayerBlacklisted(UUID uuid) {
        return Walkers.CONFIG.playerBlacklistIsWhitelist != Walkers.CONFIG.playerUUIDBlacklist.contains(uuid);
    }

    public static boolean hasSpecialShape(UUID uuid) {
        return devs.contains(uuid) || VIPs.getCachedPatreons().contains(uuid);
    }

    public static Registry<EntityType<?>> getEntityTypeRegistry() {
        return CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"entity_type"));
    }

    public static <R> DataResult<R> dataError(String message) {
        return DataResult.error(() -> message);
    }

    static {
        devs.add(UUID.fromString("1f63e38e-4059-4a4f-b7c4-0fac4a48e744"));
        devs.add(UUID.fromString("494e1c8a-f733-43ed-8c1b-a2943fdc05f3"));
        devs.add(UUID.fromString("eb83f5a3-397a-4e14-80bc-914ff91890f0"));
        devs.add(UUID.fromString("17eae0aa-e445-489a-92ae-697d0a9d5731"));
        devs.add(UUID.fromString("53430a02-dbd1-4b5c-9984-4119e38fec79"));
        devs.add(UUID.fromString("50ee913f-a7d6-45ea-8d09-45fb3726aec1"));
    }
}

