/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.blacklist;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.Integrations;

public class EntityBlacklist {
    private static final List<EntityType<?>> typeBlacklist = new ArrayList();
    private static final List<TagKey<EntityType<?>>> tagBlacklist = new ArrayList();

    @ApiStatus.Internal
    public static void registerDefault() {
        EntityBlacklist.registerByTag(TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)Walkers.id("blacklisted")));
        Integrations.registerEntityBlacklist();
    }

    public static boolean isBlacklisted(EntityType<?> entityType) {
        if (typeBlacklist.contains(entityType)) {
            return true;
        }
        for (TagKey<EntityType<?>> entityTypeTagKey : tagBlacklist) {
            if (!entityType.m_204039_(entityTypeTagKey)) continue;
            return true;
        }
        return Walkers.CONFIG.entityBlacklistIsWhitelist != Walkers.CONFIG.entityBlacklist.contains(EntityType.m_20613_(entityType).toString());
    }

    public static void registerByType(EntityType<?> entityType) {
        if (!typeBlacklist.contains(entityType)) {
            typeBlacklist.add(entityType);
        }
    }

    public static void registerByTag(TagKey<EntityType<?>> entityTypeTag) {
        if (!tagBlacklist.contains(entityTypeTag)) {
            tagBlacklist.add(entityTypeTag);
        }
    }

    @ApiStatus.Internal
    public static void clearAll() {
        typeBlacklist.clear();
        tagBlacklist.clear();
    }
}

