/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.integrations.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.integrations.impl.GuardVillagersIntegration;

public class MoreMobVariantsIntegration
extends AbstractIntegration {
    public static final String MODID = "moremobvariants";

    @Override
    public void registerTypeProvider() {
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20553_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20555_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20557_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20524_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20479_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20499_);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.f_20501_);
    }

    private static <L extends LivingEntity> void registerMMVTypeProvider(EntityType<L> type) {
        TypeProviderRegistry.register(type, new MMVTypeProvider<L>(type));
    }

    private static List<ResourceLocation> getVariants(EntityType<?> type) {
        try {
            Class<?> variantsClass = Class.forName("com.github.nyuppo.config.Variants");
            Method getVariants = variantsClass.getDeclaredMethod("getVariants", EntityType.class);
            List variants = (List)getVariants.invoke(null, type);
            ArrayList<ResourceLocation> variantIds = new ArrayList<ResourceLocation>();
            for (Object variant : variants) {
                ResourceLocation id = (ResourceLocation)variant.getClass().getDeclaredMethod("getIdentifier", new Class[0]).invoke(variant, new Object[0]);
                variantIds.add(id);
            }
            return variantIds;
        }
        catch (ReflectiveOperationException e) {
            Walkers.LOGGER.error("{}: failed to get the mob blacklist for {}: {}", new Object[]{GuardVillagersIntegration.class.getSimpleName(), MODID, e});
            return new ArrayList<ResourceLocation>();
        }
    }

    private static class MMVTypeProvider<L extends LivingEntity>
    extends TypeProvider<L> {
        private final EntityType<L> type;

        public MMVTypeProvider(EntityType<L> type) {
            this.type = type;
        }

        @Override
        public int getVariantData(L entity) {
            List<ResourceLocation> variants = MoreMobVariantsIntegration.getVariants(this.type);
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            ResourceLocation id = Identifier.parse((String)nbt.m_128461_("VariantID"));
            return variants.indexOf(id);
        }

        @Override
        public L create(EntityType<L> type, Level world, int data) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("id", EntityType.m_20613_(type).toString());
            ResourceLocation variantId = MoreMobVariantsIntegration.getVariants(type).get(data);
            nbt.m_128359_("VariantID", variantId.toString());
            return (L)((LivingEntity)EntityType.m_20645_((CompoundTag)nbt, (Level)world, entity -> entity));
        }

        @Override
        public int getFallbackData() {
            return 0;
        }

        @Override
        public int getRange() {
            return MoreMobVariantsIntegration.getVariants(this.type).size() - 1;
        }

        @Override
        public Component modifyText(L entity, MutableComponent text) {
            List<ResourceLocation> variants = MoreMobVariantsIntegration.getVariants(this.type);
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            ResourceLocation id = Identifier.parse((String)nbt.m_128461_("VariantID"));
            return TComponent.literal((String)(this.formatTypePrefix(id.m_135815_()) + " ")).m_7220_((Component)text);
        }
    }
}

