/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.NoPhysicsTrait;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DimensionsRefresher {
    @Shadow
    private EntityDimensions f_19815_;
    @Shadow
    protected boolean f_19803_;
    @Shadow
    private float f_19816_;

    @Inject(method={"getBbWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)Float.valueOf(shape.m_20205_()));
        }
    }

    @Inject(method={"getBbHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)Float.valueOf(shape.m_20206_()));
        }
    }

    @Override
    public void shape_refreshDimensions() {
        EntityDimensions newDimensions;
        EntityDimensions currentDimensions = this.f_19815_;
        Pose entityPose = ((Entity)this).m_20089_();
        this.f_19815_ = newDimensions = ((Entity)this).m_6972_(entityPose);
        this.f_19816_ = ((Entity)this).m_20236_(entityPose);
        AABB box = ((Entity)this).m_20191_();
        ((Entity)this).m_20011_(new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82288_ + (double)newDimensions.f_20377_, box.f_82289_ + (double)newDimensions.f_20378_, box.f_82290_ + (double)newDimensions.f_20377_));
        if (!this.f_19803_) {
            float f = currentDimensions.f_20377_ - newDimensions.f_20377_;
            ((Entity)this).m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight()F"}, cancellable=true)
    public void getEyeHeight(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) != null) {
            if (((Entity)this).m_6047_() && TraitRegistry.has(shape, HumanoidTrait.ID)) {
                cir.setReturnValue((Object)Float.valueOf(shape.m_20236_(Pose.CROUCHING) * 1.27f / 1.62f));
                return;
            }
            cir.setReturnValue((Object)Float.valueOf(shape.m_20192_()));
        }
    }

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)shape.m_6095_().m_20672_());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void goThroughBlocks(CallbackInfo ci) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null && TraitRegistry.has(shape, NoPhysicsTrait.ID)) {
            player.f_19794_ = true;
        }
    }

    @Inject(method={"removePassenger"}, at={@At(value="TAIL")})
    private void removePlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!CEntity.level((Entity)vehicle).f_46443_) {
                vehicle.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }

    @Inject(method={"addPassenger"}, at={@At(value="TAIL")})
    private void addPlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!CEntity.level((Entity)vehicle).f_46443_) {
                vehicle.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }
}

