/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.LivingEntityMixin;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.IronGolemEntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.accessor.RavagerEntityAccessor;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.AttackForHealthTrait;
import tocraft.walkers.traits.impl.BurnInDaylightTrait;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.InstantDieOnDamageMsgTrait;
import tocraft.walkers.traits.impl.ReinforcementsTrait;
import tocraft.walkers.traits.impl.TemperatureTrait;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        LivingEntity entity = PlayerShape.getCurrentShape((Player)this);
        if (entity != null) {
            EntityDimensions shapeDimensions = entity.m_6972_(pose);
            if (pose == Pose.CROUCHING && TraitRegistry.has(entity, HumanoidTrait.ID)) {
                cir.setReturnValue((Object)EntityDimensions.m_20395_((float)shapeDimensions.f_20377_, (float)(shapeDimensions.f_20378_ * 1.5f / 1.8f)));
            } else {
                cir.setReturnValue((Object)shapeDimensions);
            }
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    protected void shape_tryAttack(Entity target, CallbackInfo ci) {
        Bee bee;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof IronGolem) {
            IronGolem golem = (IronGolem)shape;
            ((IronGolemEntityAccessor)golem).setAttackTicksLeft(10);
        } else if (shape instanceof Warden) {
            Warden warden = (Warden)shape;
            warden.f_219313_.m_216977_(this.f_19797_);
        } else if (shape instanceof Ravager) {
            Ravager ravager = (Ravager)shape;
            ((RavagerEntityAccessor)ravager).setAttackTick(10);
        } else if (shape instanceof WitherSkeleton && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200), (Entity)this);
        } else if (shape instanceof Bee && (bee = (Bee)shape).m_21660_() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200), (Entity)this);
        } else if (shape instanceof Pufferfish) {
            LivingEntity livingTarget;
            Pufferfish pufferfish = (Pufferfish)shape;
            int i = pufferfish.m_29631_();
            if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_6469_(this.m_269291_().m_269333_((LivingEntity)((Player)this)), (float)(1 + i))) {
                livingTarget.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)((Player)this));
                this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
                if (livingTarget instanceof ServerPlayer) {
                    ServerPlayer serverPlayerTarget = (ServerPlayer)livingTarget;
                    if (!this.m_20067_()) {
                        serverPlayerTarget.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
                    }
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickGolemAttackTicks(CallbackInfo ci) {
        IronGolem golem;
        IronGolemEntityAccessor accessor;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof IronGolem && (accessor = (IronGolemEntityAccessor)(golem = (IronGolem)shape)).getAttackTicksLeft() > 0) {
            accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        Ravager ravager;
        RavagerEntityAccessor accessor;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof Ravager && (accessor = (RavagerEntityAccessor)(ravager = (Ravager)shape)).getAttackTick() > 0) {
            accessor.setAttackTick(accessor.getAttackTick() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickWardenSneakingAnimation(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof Warden) {
            Warden warden = (Warden)shape;
            if (this.m_6144_()) {
                if (!warden.f_219316_.m_216984_()) {
                    warden.f_219316_.m_216977_(this.f_19797_);
                }
            } else {
                warden.f_219316_.m_216973_();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickFire(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (!CEntity.level((Entity)player).f_46443_ && !player.m_7500_() && !player.m_5833_() && shape != null && TraitRegistry.has(shape, BurnInDaylightTrait.ID)) {
            boolean bl = this.walkers$isInDaylight();
            for (BurnInDaylightTrait trait2 : TraitRegistry.get(shape, BurnInDaylightTrait.ID).stream().map(trait -> (BurnInDaylightTrait)trait).toList()) {
                bl = bl && !trait2.burnInMoonlightInstead || !this.walkers$isInDaylight() && trait2.burnInMoonlightInstead;
            }
            if (bl) {
                if (CEntity.level((Entity)player).m_46471_()) {
                    return;
                }
                ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
                if (!itemStack.m_41619_()) {
                    if (itemStack.m_41763_()) {
                        itemStack.m_41721_(itemStack.m_41773_() + player.m_217043_().m_188503_(2));
                        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                            player.m_21166_(EquipmentSlot.HEAD);
                            player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    player.m_20254_(8);
                }
            }
        }
    }

    @Unique
    private boolean walkers$isInDaylight() {
        if (CEntity.level((Entity)this).m_46461_() && !CEntity.level((Entity)this).f_46443_) {
            float brightnessAtEyes = this.m_213856_();
            BlockPos daylightTestPosition = BlockPos.m_274561_((double)this.m_20185_(), (double)Math.round(this.m_20186_()), (double)this.m_20189_());
            if (this.m_20202_() instanceof Boat) {
                daylightTestPosition = daylightTestPosition.m_7494_();
            }
            return brightnessAtEyes > 0.5f && this.f_19796_.m_188501_() * 30.0f < (brightnessAtEyes - 0.4f) * 2.0f && CEntity.level((Entity)this).m_45527_(daylightTestPosition);
        }
        return false;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickTemperature(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (!player.m_7500_() && !player.m_5833_() && shape != null) {
            boolean couldEnoughToSnow = ((Biome)CEntity.level((Entity)this).m_204166_(this.m_20183_()).m_203334_()).m_198904_(this.m_20183_());
            for (TemperatureTrait temperaturetrait : TraitRegistry.get(shape, TemperatureTrait.ID).stream().map(entry -> (TemperatureTrait)entry).toList()) {
                if (!temperaturetrait.coldEnoughToSnow != couldEnoughToSnow) continue;
                player.m_6469_(CEntity.level((Entity)this).m_269111_().m_269549_(), 1.0f);
                break;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickWalkers(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (shape != null) {
            shape.m_20260_(player.m_6144_());
            shape.m_20124_(player.m_20089_());
            shape.m_20282_(player.m_6069_());
            if (!CEntity.level((Entity)this).f_46443_) {
                shape.m_20343_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                shape.m_5616_(player.m_6080_());
                shape.m_6862_(((LivingEntityAccessor)player).isJumping());
                shape.m_6858_(player.m_20142_());
                shape.m_21317_(player.m_21234_());
                shape.m_20331_(true);
                shape.m_20242_(true);
                shape.m_20282_(player.m_6069_());
                shape.m_6672_(player.m_7655_());
                if (shape instanceof TamableAnimal) {
                    ((TamableAnimal)shape).m_21837_(player.m_6144_());
                    ((TamableAnimal)shape).m_21839_(player.m_6144_());
                } else if (shape instanceof Fox) {
                    ((Fox)shape).m_28610_(player.m_6144_());
                    ((Fox)shape).m_6862_(!CEntity.isOnGround((Entity)player));
                }
                ((EntityAccessor)shape).shape_callSetFlag(7, player.m_21255_());
                ((LivingEntityAccessor)shape).callUpdatingUsingItem();
                PlayerShape.sync((ServerPlayer)player);
            }
        }
    }

    @Inject(method={"makeStuckInBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStuckInBlock(BlockState state, Vec3 motionMultiplier, CallbackInfo ci) {
        if (PlayerShape.getCurrentShape((Player)this) instanceof Spider && state.m_60713_(Blocks.f_50033_)) {
            ci.cancel();
        }
    }

    @Inject(method={"touch"}, at={@At(value="HEAD")})
    private void onTouch(Entity entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        Player ownPlayer = (Player)this;
        if (ownPlayer.m_6084_() && (livingEntity = PlayerShape.getCurrentShape(ownPlayer)) instanceof Slime) {
            Player targetPlayer;
            Slime slimeShape = (Slime)livingEntity;
            if (entity instanceof Player && !(PlayerShape.getCurrentShape(targetPlayer = (Player)entity) instanceof Slime)) {
                int i = slimeShape.m_33632_();
                boolean wasHurt = targetPlayer.m_6469_(ownPlayer.m_269291_().m_269333_((LivingEntity)ownPlayer), (float)ownPlayer.m_21133_(Attributes.f_22281_));
                if (this.m_20280_((Entity)targetPlayer) < 0.6 * (double)i * 0.6 * (double)i && ownPlayer.m_142582_((Entity)targetPlayer) && wasHurt) {
                    this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_19970_((LivingEntity)ownPlayer, (Entity)targetPlayer);
                }
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void handeReinforcementsTrait(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        Object object = source.m_7639_();
        if (object instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)object;
            if (shape != null && (object = TraitRegistry.get(shape, ReinforcementsTrait.ID).stream().map(trait -> (ReinforcementsTrait)trait).toList().iterator()).hasNext()) {
                ReinforcementsTrait reinforcementTrait = (ReinforcementsTrait)object.next();
                double d = reinforcementTrait.getRange();
                AABB aABB = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d, 10.0, d);
                Iterator var5 = CEntity.level((Entity)this).m_6443_(Mob.class, aABB, EntitySelector.f_20408_.and(entity -> {
                    if (reinforcementTrait.hasReinforcements()) {
                        return reinforcementTrait.isReinforcement((Entity)entity);
                    }
                    return shape.getClass().isInstance(entity);
                })).iterator();
                while (true) {
                    boolean bl;
                    if (!var5.hasNext()) {
                        return;
                    }
                    Mob mob = (Mob)var5.next();
                    if (shape == mob || mob.m_5448_() != null || (bl = false)) continue;
                    mob.m_6710_(livingAttacker);
                }
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void instantDieOnDamageTypeTrait(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null) {
            for (ShapeTrait<LivingEntity> instantDieOnDamageTypetrait : TraitRegistry.get(shape, InstantDieOnDamageMsgTrait.ID)) {
                if (!source.m_19385_().equals(((InstantDieOnDamageMsgTrait)instantDieOnDamageTypetrait).msgId)) continue;
                this.m_6074_();
            }
        }
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;tick(Lnet/minecraft/world/entity/player/Player;)V")})
    private boolean preventFoodDataTick(FoodData instance, Player player) {
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        return player.m_21023_(MobEffects.f_19618_) || !TraitRegistry.has(shape, AttackForHealthTrait.ID);
    }

    @Inject(method={"canEat"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanEat(boolean canAlwaysEat, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && TraitRegistry.has(PlayerShape.getCurrentShape((Player)this), AttackForHealthTrait.ID)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void onExhaustion(float exhaustion, CallbackInfo ci) {
        if (TraitRegistry.has(PlayerShape.getCurrentShape((Player)this), AttackForHealthTrait.ID)) {
            ci.cancel();
        }
    }
}

