/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class GetItemAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    private final ItemStack itemStack;
    public static final ResourceLocation ID = Walkers.id("get_item");
    public static final MapCodec<GetItemAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(o -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"item")).getKey((Object)o.itemStack.getItem())), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(o -> o.itemStack.getCount())).apply((Applicative)instance, instance.stable((item, amount) -> new GetItemAbility(new ItemStack((ItemLike)Objects.requireNonNull((Item)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"item")).get(item)), amount.intValue())))));

    public GetItemAbility(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        player.getInventory().add(this.itemStack);
    }

    @Override
    public Item getIcon() {
        return this.itemStack.getItem();
    }

    @Override
    public int getDefaultCooldown() {
        return 600;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}

