/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class ThrowPotionsAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    public static final List<Potion> VALID_POTIONS = Arrays.asList(Potions.HARMING, Potions.POISON, Potions.SLOWNESS, Potions.WEAKNESS);
    private final List<Potion> validPotions;
    public static final ResourceLocation ID = Walkers.id("throw_potion");
    public static final MapCodec<ThrowPotionsAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("potions", VALID_POTIONS.stream().map(o -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).getKey(o)).toList()).forGetter(o -> o.validPotions.stream().map(o1 -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).getKey(o1)).toList())).apply((Applicative)instance, instance.stable(validPotions -> new ThrowPotionsAbility(validPotions.stream().map(o -> (Potion)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).get(o)).toList()))));

    public ThrowPotionsAbility(List<Potion> validPotions) {
        this.validPotions = validPotions;
    }

    public ThrowPotionsAbility() {
        this(VALID_POTIONS);
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        ThrownPotion potionEntity = new ThrownPotion(world, (LivingEntity)player);
        potionEntity.setItem(PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.SPLASH_POTION), (Potion)this.validPotions.get(world.random.nextInt(this.validPotions.size()))));
        potionEntity.setXRot(-20.0f);
        Vec3 rotation = player.getLookAngle();
        potionEntity.shoot(rotation.x(), rotation.y(), rotation.z(), 0.75f, 8.0f);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITCH_THROW, player.getSoundSource(), 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
        world.addFreshEntity((Entity)potionEntity);
    }

    @Override
    public Item getIcon() {
        return Items.POTION;
    }

    @Override
    public int getDefaultCooldown() {
        return 200;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}

