/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.specific;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;

public class SnifferAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("sniffer");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        if (player.isInLava() || player.isInWater() || !CEntity.isOnGround((Entity)player)) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        BlockPos blockPos = new BlockPos(playerPos.getX(), playerPos.getY() - 1, playerPos.getZ());
        ArrayList<Block> diggableBlocks = new ArrayList<Block>();
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:dirt")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:grass_block")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:podzol")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:rooted_dirt")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:moss_block")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:mud")));
        diggableBlocks.add((Block)BuiltInRegistries.BLOCK.get(Identifier.parse((String)"minecraft:muddy_mangrove_roots")));
        if (diggableBlocks.contains(world.getBlockState(blockPos).getBlock()) && Math.random() <= 0.5) {
            if (SnifferAbility.getRandomBoolean()) {
                player.spawnAtLocation((ItemLike)Items.TORCHFLOWER_SEEDS);
            } else {
                player.spawnAtLocation((ItemLike)Items.PITCHER_POD);
            }
            world.playSound(null, (Entity)player, SoundEvents.SNIFFER_DIGGING, SoundSource.PLAYERS, 1.0f, (world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f);
        } else {
            world.playSound(null, (Entity)player, SoundEvents.SNIFFER_DIGGING_STOP, SoundSource.PLAYERS, 1.0f, (world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public Item getIcon() {
        return Items.TORCHFLOWER;
    }

    private static boolean getRandomBoolean() {
        return Math.random() < 0.5;
    }

    @Override
    public int getDefaultCooldown() {
        return 9600;
    }
}

