/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;

public class PlayerAbilities {
    public static int getCooldown(Player player) {
        return ((PlayerDataProvider)player).walkers$getAbilityCooldown();
    }

    public static boolean canUseAbility(@NotNull Player player) {
        return !player.isSpectator() && ((PlayerDataProvider)player).walkers$getAbilityCooldown() <= 0;
    }

    public static void setCooldown(Player player, int cooldown) {
        ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown);
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer player) {
        CompoundTag packet = new CompoundTag();
        packet.putInt("cooldown", ((PlayerDataProvider)player).walkers$getAbilityCooldown());
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.ABILITY_SYNC, (CompoundTag)packet);
    }

    public static void useAbility(Player player) {
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (shape != null && AbilityRegistry.has(shape) && PlayerAbilities.canUseAbility(player)) {
            ShapeAbility<LivingEntity> ability = AbilityRegistry.get(shape);
            if (ability == null) {
                return;
            }
            InteractionResult result = ((ShapeEvents.UseShapeAbilityCallback)ShapeEvents.USE_SHAPE_ABILITY.invoke()).use(player, ability);
            if (result == InteractionResult.FAIL) {
                return;
            }
            ability.onUse(player, shape, CEntity.level((Entity)player));
            PlayerAbilities.setCooldown(player, ability.getCooldown(shape));
            PlayerAbilities.sync((ServerPlayer)player);
        }
    }
}

