/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.api.variant.TypeProvider;

public class CatTypeProvider
extends TypeProvider<Cat> {
    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap.builder().put((Object)0, (Object)"Tabby").put((Object)1, (Object)"Black").put((Object)2, (Object)"Red").put((Object)3, (Object)"Siamese").put((Object)4, (Object)"British Shorthair").put((Object)5, (Object)"Calico").put((Object)6, (Object)"Persian").put((Object)7, (Object)"Ragdoll").put((Object)8, (Object)"White").put((Object)9, (Object)"Jellie").put((Object)10, (Object)"Black").build();

    @Override
    public int getVariantData(Cat entity) {
        return BuiltInRegistries.CAT_VARIANT.getId((Object)entity.getVariant());
    }

    @Override
    public Cat create(EntityType<Cat> type, Level world, int data) {
        Cat cat = new Cat(type, world);
        cat.setVariant((CatVariant)BuiltInRegistries.CAT_VARIANT.byId(data));
        return cat;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return BuiltInRegistries.CAT_VARIANT.size() - 1;
    }

    @Override
    public Component modifyText(Cat cat, MutableComponent text) {
        int variant = this.getVariantData(cat);
        return TComponent.literal((String)(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "")).append((Component)text);
    }
}

