/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.NoPhysicsTrait;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DimensionsRefresher {
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    protected boolean firstTick;
    @Shadow
    private float eyeHeight;

    @Inject(method={"getBbWidth()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)Float.valueOf(shape.getBbWidth()));
        }
    }

    @Inject(method={"getBbHeight()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)Float.valueOf(shape.getBbHeight()));
        }
    }

    @Override
    public void shape_refreshDimensions() {
        EntityDimensions newDimensions;
        EntityDimensions currentDimensions = this.dimensions;
        Pose entityPose = ((Entity)this).getPose();
        this.dimensions = newDimensions = ((Entity)this).getDimensions(entityPose);
        this.eyeHeight = ((Entity)this).getEyeHeight(entityPose);
        AABB box = ((Entity)this).getBoundingBox();
        ((Entity)this).setBoundingBox(new AABB(box.minX, box.minY, box.minZ, box.minX + (double)newDimensions.width, box.minY + (double)newDimensions.height, box.minZ + (double)newDimensions.width));
        if (!this.firstTick) {
            float f = currentDimensions.width - newDimensions.width;
            ((Entity)this).move(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight()F"}, cancellable=true)
    public void getEyeHeight(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntity shape;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) != null) {
            if (((Entity)this).isCrouching() && TraitRegistry.has(shape, HumanoidTrait.ID)) {
                cir.setReturnValue((Object)Float.valueOf(shape.getEyeHeight(Pose.CROUCHING) * 1.27f / 1.62f));
                return;
            }
            cir.setReturnValue((Object)Float.valueOf(shape.getEyeHeight()));
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)shape.getType().fireImmune());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void goThroughBlocks(CallbackInfo ci) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null && TraitRegistry.has(shape, NoPhysicsTrait.ID)) {
            player.noPhysics = true;
        }
    }

    @Inject(method={"removePassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void removePlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!CEntity.level((Entity)vehicle).isClientSide) {
                vehicle.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }

    @Inject(method={"addPassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void addPlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!CEntity.level((Entity)vehicle).isClientSide) {
                vehicle.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }
}

