/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.RiderTrait;

@Mixin(value={Player.class})
public abstract class PlayerEntityDataMixin
extends LivingEntity
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    @Nullable
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    @Nullable
    private LivingEntity walkers$shape = null;
    @Unique
    private float walkers$normalHealth = -1.0f;

    private PlayerEntityDataMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        CompoundTag unlockedShape = tag.getCompound("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);
        this.walkers$abilityCooldown = tag.getInt(ABILITY_COOLDOWN_KEY);
        this.walkers$remainingTime = tag.getInt("RemainingHostilityTime");
        this.walkers$normalHealth = tag.getFloat("walkersHealth");
        this.walkers$readCurrentShape(tag.getCompound("CurrentShape"));
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        CompoundTag id = new CompoundTag();
        if (this.walkers$unlocked != null) {
            id = this.walkers$unlocked.writeCompound();
        }
        tag.put("UnlockedShape", (Tag)id);
        tag.putInt(ABILITY_COOLDOWN_KEY, this.walkers$abilityCooldown);
        tag.putInt("RemainingHostilityTime", this.walkers$remainingTime);
        tag.putFloat("walkersHealth", this.walkers$normalHealth);
        tag.put("CurrentShape", (Tag)this.walkers$writeCurrentShape(new CompoundTag()));
    }

    @Unique
    private CompoundTag walkers$writeCurrentShape(CompoundTag tag) {
        CompoundTag entityTag = new CompoundTag();
        if (this.walkers$shape != null) {
            this.walkers$shape.saveWithoutId(entityTag);
        }
        tag.putString("id", this.walkers$shape == null ? "minecraft:empty" : EntityType.getKey((EntityType)this.walkers$shape.getType()).toString());
        tag.put("EntityData", (Tag)entityTag);
        return tag;
    }

    @Unique
    public void walkers$readCurrentShape(CompoundTag tag) {
        CompoundTag entityTag;
        Optional type = EntityType.by((CompoundTag)tag);
        if (tag.getString("id").equals("minecraft:empty")) {
            this.walkers$shape = null;
            ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
        } else if (type.isPresent() && !(entityTag = tag.getCompound("EntityData")).isEmpty()) {
            if (this.walkers$shape == null || !((EntityType)type.get()).equals(this.walkers$shape.getType())) {
                this.walkers$shape = (LivingEntity)((EntityType)type.get()).create(CEntity.level((Entity)this));
                ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
            }
            this.walkers$shape.load(entityTag);
        }
    }

    @Override
    @Unique
    @Nullable
    public ShapeType<?> walkers$get2ndShape() {
        return this.walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Override
    @Unique
    public int walkers$getRemainingHostilityTime() {
        return this.walkers$remainingTime;
    }

    @Override
    @Unique
    public void walkers$setRemainingHostilityTime(int max) {
        this.walkers$remainingTime = max;
    }

    @Override
    @Unique
    public int walkers$getAbilityCooldown() {
        return this.walkers$abilityCooldown;
    }

    @Override
    @Unique
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    @Nullable
    public LivingEntity walkers$getCurrentShape() {
        return this.walkers$shape;
    }

    @Override
    @Unique
    public void walkers$setCurrentShape(LivingEntity shape) {
        this.walkers$shape = shape;
    }

    @Override
    @Unique
    public void walkers$updateShapes(@Nullable LivingEntity shape) {
        float currentHealthPercent;
        Player player = (Player)this;
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance armorAttribute = player.getAttribute(Attributes.ARMOR);
        AttributeInstance armorToughnessAttribute = player.getAttribute(Attributes.ARMOR_TOUGHNESS);
        this.walkers$shape = shape;
        ((DimensionsRefresher)player).shape_refreshDimensions();
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                this.walkers$normalHealth = player.getMaxHealth();
                currentHealthPercent = player.getHealth() / player.getMaxHealth();
                healthAttribute.setBaseValue((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.getMaxHealth()));
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.setHealth(Math.min(currentHealthPercent * player.getMaxHealth(), player.getMaxHealth()));
                } else {
                    player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                AttributeInstance shapeArmorAttribute = shape.getAttribute(Attributes.ARMOR);
                if (armorAttribute != null && shapeArmorAttribute != null) {
                    armorAttribute.setBaseValue(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorAttribute.getBaseValue()));
                }
                AttributeInstance shapeArmorToughnessAttribute = shape.getAttribute(Attributes.ARMOR_TOUGHNESS);
                if (armorToughnessAttribute != null && shapeArmorToughnessAttribute != null) {
                    armorToughnessAttribute.setBaseValue(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorToughnessAttribute.getBaseValue()));
                }
            }
        }
        if (shape == null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                currentHealthPercent = player.getHealth() / player.getMaxHealth();
                float health = Walkers.CONFIG.player_health;
                if (health < 0.0f) {
                    health = this.walkers$normalHealth > 0.0f ? this.walkers$normalHealth : 20.0f;
                }
                healthAttribute.setBaseValue((double)health);
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.setHealth(Math.min(currentHealthPercent * player.getMaxHealth(), player.getMaxHealth()));
                } else {
                    player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                if (armorAttribute != null) {
                    armorAttribute.setBaseValue(0.0);
                }
                if (armorToughnessAttribute != null) {
                    armorAttribute.setBaseValue(0.0);
                }
            }
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (Walkers.hasFlyingPermissions((ServerPlayer)player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            FlightHelper.updateFlyingSpeed(player);
            player.onUpdateAbilities();
        } else if (!player.isCreative()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.getAbilities().setFlyingSpeed(0.05f);
            player.onUpdateAbilities();
        }
        Entity entity = player.getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity;
            boolean b1 = false;
            boolean b2 = false;
            for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                Player rideablePlayer;
                if (riderTrait.isRideable(livingVehicle) || livingVehicle instanceof Player && riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (Player)livingVehicle))) {
                    b1 = true;
                    b2 = true;
                }
                if (!b2) continue;
                break;
            }
            if (!b1) {
                player.stopRiding();
            }
        }
        if (!(shape instanceof AbstractHorse)) {
            for (Entity passenger : player.getPassengers()) {
                passenger.stopRiding();
            }
        }
        if (!CEntity.level((Entity)player).isClientSide) {
            PlayerShape.sync((ServerPlayer)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)CEntity.level((Entity)player)).getChunkSource().chunkMap).getEntityMap();
            Object tracking = trackers.get(player.getId());
            ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((ServerPlayer)player, listener.getPlayer()));
        }
    }
}

