/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.specific.GrassEaterAbility;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.DolphinAccessor;
import tocraft.walkers.mixin.accessor.PufferfishAccessor;
import tocraft.walkers.mixin.accessor.SheepAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.MobEffectTrait;

@Mixin(value={Player.class})
public abstract class PlayerEntityTickMixin
extends LivingEntity {
    @Unique
    private static Predicate<BlockState> walkers$IS_TALL_GRASS = null;

    private PlayerEntityTickMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        WalkersTickHandler<?> handler;
        @Nullable LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null && (handler = WalkersTickHandlers.getHandlers().get(shape.getType())) != null) {
            handler.tick((Player)this, shape);
        }
        if (!CEntity.level((Entity)this).isClientSide) {
            PlayerDataProvider data = (PlayerDataProvider)((Object)this);
            data.walkers$setRemainingHostilityTime(Math.max(0, data.walkers$getRemainingHostilityTime() - 1));
            ServerPlayer player = (ServerPlayer)this;
            PlayerAbilities.setCooldown((Player)player, Math.max(0, data.walkers$getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void setShapeData(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof ShapeDataProvider) {
            ShapeDataProvider shapeData = (ShapeDataProvider)shape;
            shapeData.walkers$ShapedPlayer(this.getId());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void pufferfishServerTick(CallbackInfo info) {
        LivingEntity shape;
        if (!CEntity.level((Entity)this).isClientSide && this.isAlive() && (shape = PlayerShape.getCurrentShape((Player)this)) instanceof Pufferfish) {
            Pufferfish pufferfishShape = (Pufferfish)shape;
            if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 0) {
                if (pufferfishShape.getPuffState() == 0) {
                    this.playSound(SoundEvents.PUFFER_FISH_BLOW_UP, this.getSoundVolume(), this.getVoicePitch());
                    pufferfishShape.setPuffState(1);
                } else if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 40 && pufferfishShape.getPuffState() == 1) {
                    this.playSound(SoundEvents.PUFFER_FISH_BLOW_UP, this.getSoundVolume(), this.getVoicePitch());
                    pufferfishShape.setPuffState(2);
                }
                ((PufferfishAccessor)pufferfishShape).setInflateCounter(((PufferfishAccessor)pufferfishShape).getInflateCounter() + 1);
            } else if (pufferfishShape.getPuffState() != 0) {
                if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 60 && pufferfishShape.getPuffState() == 2) {
                    this.playSound(SoundEvents.PUFFER_FISH_BLOW_OUT, this.getSoundVolume(), this.getVoicePitch());
                    pufferfishShape.setPuffState(1);
                } else if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 100 && pufferfishShape.getPuffState() == 1) {
                    this.playSound(SoundEvents.PUFFER_FISH_BLOW_OUT, this.getSoundVolume(), this.getVoicePitch());
                    pufferfishShape.setPuffState(0);
                }
                ((PufferfishAccessor)pufferfishShape).setDeflateTimer(((PufferfishAccessor)pufferfishShape).getDeflateTimer() + 1);
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void dolphinServerTick(CallbackInfo info) {
        Player nearestPlayer;
        Player player;
        LivingEntity shape;
        if (!CEntity.level((Entity)this).isClientSide && this.isAlive() && (shape = PlayerShape.getCurrentShape(player = (Player)this)) instanceof Dolphin && (nearestPlayer = CEntity.level((Entity)player).getNearestPlayer(DolphinAccessor.getSWIM_WITH_PLAYER_TARGETING(), (LivingEntity)player)) != null && nearestPlayer.isSwimming()) {
            nearestPlayer.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 100), (Entity)player);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void applyMobEffectTrait(CallbackInfo info) {
        Player player;
        LivingEntity shape;
        if (!CEntity.level((Entity)this).isClientSide && this.isAlive() && TraitRegistry.has(shape = PlayerShape.getCurrentShape(player = (Player)this), MobEffectTrait.ID)) {
            List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
            block5: for (MobEffectTrait mobEffectTrait : traitList) {
                MobEffectInstance mobEffectInstance = mobEffectTrait.mobEffectInstance;
                if (mobEffectTrait.showInInventory && mobEffectTrait.applyToSelf) {
                    player.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()), (Entity)player);
                }
                switch (mobEffectTrait.applyToNearby) {
                    case 0: {
                        List nearbyPlayers = CEntity.level((Entity)player).getNearbyPlayers(TargetingConditions.forNonCombat().range((double)mobEffectTrait.maxDistanceForEntities).ignoreLineOfSight(), (LivingEntity)player, player.getBoundingBox().inflate((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyPlayers.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyPlayers.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Player)nearbyPlayers.get(i)).addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()), (Entity)player);
                        }
                        continue block5;
                    }
                    case 1: {
                        List nearbyMobs = CEntity.level((Entity)player).getNearbyEntities(Mob.class, TargetingConditions.forNonCombat().range((double)mobEffectTrait.maxDistanceForEntities).ignoreLineOfSight(), (LivingEntity)player, player.getBoundingBox().inflate((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyMobs.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyMobs.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Mob)nearbyMobs.get(i)).addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()), (Entity)player);
                        }
                        continue block5;
                    }
                    case 2: {
                        List nearbyMobs = CEntity.level((Entity)player).getNearbyEntities(Mob.class, TargetingConditions.forNonCombat().range((double)mobEffectTrait.maxDistanceForEntities).ignoreLineOfSight(), (LivingEntity)player, player.getBoundingBox().inflate((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        List nearbyPlayers = CEntity.level((Entity)player).getNearbyPlayers(TargetingConditions.forNonCombat().range((double)mobEffectTrait.maxDistanceForEntities).ignoreLineOfSight(), (LivingEntity)player, player.getBoundingBox().inflate((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        ArrayList nearbyEntites = new ArrayList();
                        nearbyEntites.addAll(nearbyMobs);
                        nearbyEntites.addAll(nearbyPlayers);
                        nearbyEntites.sort((first, second) -> Float.compare(player.distanceTo((Entity)first), player.distanceTo((Entity)second)));
                        if (nearbyEntites.isEmpty()) break;
                        for (int i = 0; i < nearbyEntites.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((Mob)nearbyMobs.get(i)).addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()), (Entity)player);
                        }
                        break;
                    }
                }
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void sheepServerTick(CallbackInfo info) {
        ShapeAbility<LivingEntity> shapeAbility;
        ServerPlayer serverPlayer;
        LivingEntity shape;
        if (walkers$IS_TALL_GRASS == null) {
            walkers$IS_TALL_GRASS = BlockStatePredicate.forBlock((Block)((Block)CEntity.level((Entity)this).registryAccess().registryOrThrow(CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).key()).get(Identifier.parse((String)"grass"))));
        }
        if (!CEntity.level((Entity)this).isClientSide && this.isAlive() && (shape = PlayerShape.getCurrentShape((Player)(serverPlayer = (ServerPlayer)this))) != null && (shapeAbility = AbilityRegistry.get(shape)) instanceof GrassEaterAbility) {
            GrassEaterAbility grassEaterAbility = (GrassEaterAbility)shapeAbility;
            if (grassEaterAbility.eatTick.get(serverPlayer.getUUID()) != null && grassEaterAbility.eatTick.get(serverPlayer.getUUID()) != 0) {
                grassEaterAbility.eatTick.put(serverPlayer.getUUID(), Math.max(0, grassEaterAbility.eatTick.get(serverPlayer.getUUID()) - 1));
                if (shape instanceof Sheep) {
                    Sheep sheepShape = (Sheep)shape;
                    ((SheepAccessor)sheepShape).setEatAnimationTick(grassEaterAbility.eatTick.get(serverPlayer.getUUID()));
                }
                if (grassEaterAbility.eatTick.get(serverPlayer.getUUID()) == Mth.positiveCeilDiv((int)4, (int)2)) {
                    BlockPos blockPos = serverPlayer.blockPosition();
                    if (walkers$IS_TALL_GRASS.test(CEntity.level((Entity)this).getBlockState(blockPos)) && this.walkers$isLookingAtPos(blockPos)) {
                        CEntity.level((Entity)this).destroyBlock(blockPos, false);
                        this.gameEvent(GameEvent.EAT);
                        serverPlayer.getFoodData().eat(3, 0.2f);
                        if (shape instanceof Sheep) {
                            Sheep sheepShape = (Sheep)shape;
                            sheepShape.setSheared(false);
                        }
                    } else {
                        BlockPos blockPos2 = blockPos.below();
                        if (CEntity.level((Entity)this).getBlockState(blockPos2).is(Blocks.GRASS_BLOCK) && this.walkers$isLookingAtPos(blockPos2)) {
                            CEntity.level((Entity)this).levelEvent(2001, blockPos2, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                            CEntity.level((Entity)this).setBlock(blockPos2, Blocks.DIRT.defaultBlockState(), 2);
                            this.gameEvent(GameEvent.EAT);
                            serverPlayer.getFoodData().eat(3, 0.1f);
                            if (shape instanceof Sheep) {
                                Sheep sheepShape = (Sheep)shape;
                                sheepShape.setSheared(false);
                            }
                        }
                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isLookingAtPos(BlockPos blockPos) {
        BlockHitResult blockHitResult;
        Player player = (Player)this;
        HitResult hitResult = player.pick(2.0, 0.0f, false);
        return hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).getBlockPos().equals((Object)blockPos);
    }
}

