/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.network.impl.SyncApiLevelPackets;
import tocraft.walkers.network.impl.UnlockPackets;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.SHAPE_SYNC, ClientNetworking::handleWalkersSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.SYNC_API_LEVEL, (context, nbt) -> SyncApiLevelPackets.handleSyncPacket(nbt));
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        ModernNetworking.sendToServer((ResourceLocation)USE_ABILITY, (CompoundTag)new CompoundTag());
    }

    public static void handleWalkersSyncPacket(ModernNetworking.Context context, CompoundTag packetData) {
        UUID uuid = packetData.getUUID("uuid");
        String id = packetData.getString("type");
        CompoundTag entityNbt = packetData.getCompound("entity_tag");
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.getCommandSenderWorld().getPlayerByUUID(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                    return;
                }
                entityNbt.putString("id", id);
                Optional type = EntityType.by((CompoundTag)entityNbt);
                if (type.isPresent()) {
                    LivingEntity shape = data.walkers$getCurrentShape();
                    if (shape == null || !((EntityType)type.get()).equals(shape.getType())) {
                        shape = (LivingEntity)((EntityType)type.get()).create(CEntity.level((Entity)syncTarget));
                        data.walkers$setCurrentShape(shape);
                        ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                    }
                    if (shape != null) {
                        shape.load(entityNbt);
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(ModernNetworking.Context context, CompoundTag packet) {
        int cooldown = packet.getInt("cooldown");
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown));
    }
}

