/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.screen.hud;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class VariantMenu {
    private final Map<ShapeType<?>, LivingEntity> renderEntities = new HashMap();
    private final Map<ShapeType<?>, LivingEntity> renderSpecialEntities = new HashMap();

    public void render(GuiGraphics guiGraphics) {
        ShapeType<LivingEntity> currentShapeType;
        ClientLevel level;
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.hideGui && WalkersClient.isRenderingVariantsMenu && Walkers.CONFIG.unlockEveryVariant && minecraft.screen == null && (level = minecraft.level) != null && minecraft.player != null && (currentShapeType = ShapeType.from(PlayerShape.getCurrentShape((Player)minecraft.player))) != null) {
            int range;
            boolean hasSpecialVariant = Walkers.hasSpecialShape(minecraft.player.getUUID()) && EntityType.getKey(currentShapeType.getEntityType()).equals((Object)Identifier.parse((String)"minecraft:wolf"));
            int currentVariantId = currentShapeType.getVariantData();
            TypeProvider<LivingEntity> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
            int n = range = typeProvider != null ? typeProvider.getRange() : -1;
            if (hasSpecialVariant) {
                ++range;
                LivingEntity currentShape = PlayerShape.getCurrentShape((Player)minecraft.player);
                if (currentShape != null) {
                    CompoundTag nbt = new CompoundTag();
                    currentShape.saveWithoutId(nbt);
                    if (nbt.contains("isSpecial") && nbt.getBoolean("isSpecial")) {
                        currentVariantId = range;
                    }
                }
            }
            int x = minecraft.getWindow().getGuiScaledWidth() / 7;
            int y = minecraft.getWindow().getGuiScaledHeight() / 5;
            CGraphics.fillTransparent((GuiGraphics)guiGraphics, (int)x, (int)0, (int)(x * 6), (int)(y + 10));
            if (range > -1) {
                WalkersClient.variantOffset = Mth.clamp((int)WalkersClient.variantOffset, (int)(-currentVariantId - (hasSpecialVariant ? 1 : 0)), (int)(range - currentVariantId));
                for (int i = 1; i <= 5; ++i) {
                    ShapeType<LivingEntity> thisShapeType;
                    int thisVariantId = currentVariantId - 3 + i + WalkersClient.variantOffset;
                    LivingEntity entity = null;
                    if (hasSpecialVariant && thisVariantId == range) {
                        entity = this.renderSpecialEntities.computeIfAbsent(currentShapeType, arg_0 -> VariantMenu.lambda$render$1((Level)level, arg_0));
                    } else if ((thisVariantId > -1 || hasSpecialVariant && thisVariantId == -1) && (thisVariantId <= range || thisVariantId == currentVariantId) && (thisShapeType = ShapeType.from(currentShapeType.getEntityType(), thisVariantId)) != null) {
                        entity = this.renderEntities.computeIfAbsent(thisShapeType, arg_0 -> VariantMenu.lambda$render$2((Level)level, minecraft, arg_0));
                    }
                    if (entity == null) continue;
                    InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)x * (float)i + (float)x / 2.0f), (float)((float)y * 0.75f), (int)((int)(25.0f * (1.0f / Math.max(entity.getBbHeight(), entity.getBbWidth())))), (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)entity);
                }
            } else {
                LivingEntity entity = this.renderEntities.computeIfAbsent(currentShapeType, arg_0 -> VariantMenu.lambda$render$3((Level)level, minecraft, arg_0));
                if (entity != null) {
                    InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)x * 3.0f + (float)x / 2.0f), (float)((float)y * 0.75f), (int)((int)(25.0f * (1.0f / Math.max(entity.getBbHeight(), entity.getBbWidth())))), (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)entity);
                }
            }
            CGraphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Walkers.id("textures/gui/focused.png"), (int)(x * 3), (int)5, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)48, (int)32, (int)48, (int)32);
        }
    }

    private static /* synthetic */ LivingEntity lambda$render$3(Level level, Minecraft minecraft, ShapeType type) {
        return type.create(level, (Player)minecraft.player);
    }

    private static /* synthetic */ LivingEntity lambda$render$2(Level level, Minecraft minecraft, ShapeType type) {
        return type.create(level, (Player)minecraft.player);
    }

    private static /* synthetic */ LivingEntity lambda$render$1(Level level, ShapeType type) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("isSpecial", true);
        nbt.putString("id", EntityType.getKey(type.getEntityType()).toString());
        return (LivingEntity)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, it -> it);
    }
}

