/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class MobEffectTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("mob_effect");
    public static final Codec<MobEffectInstance> MOB_EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(o -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"mob_effect")).getKey((Object)o.getEffect())), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::getDuration), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::getAmplifier), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::isAmbient), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(MobEffectInstance::isVisible), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(o -> Optional.of(o.showIcon()))).apply((Applicative)instance, instance.stable((id, duration, amplifier, ambient, show_particles, show_icon) -> new MobEffectInstance(Objects.requireNonNull((MobEffect)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"mob_effect")).get(id)), duration.intValue(), amplifier.intValue(), ambient.booleanValue(), show_particles.booleanValue(), show_icon.orElse(show_particles).booleanValue()))));
    public static final MapCodec<MobEffectTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MOB_EFFECT_INSTANCE_CODEC.fieldOf("mob_effect").forGetter(o -> o.mobEffectInstance), (App)Codec.BOOL.optionalFieldOf("show_in_inventory", (Object)true).forGetter(o -> o.showInInventory), (App)Codec.BOOL.optionalFieldOf("apply_to_self", (Object)true).forGetter(o -> o.applyToSelf), (App)Codec.INT.optionalFieldOf("apply_to_nearby", (Object)-1).forGetter(o -> o.applyToNearby), (App)Codec.INT.optionalFieldOf("max_distance_for_entities", (Object)-1).forGetter(o -> o.maxDistanceForEntities), (App)Codec.INT.optionalFieldOf("amount_of_entities_to_apply_to", (Object)-1).forGetter(o -> o.amountOfEntitiesToApplyTo)).apply((Applicative)instance, instance.stable(MobEffectTrait::new)));
    public final MobEffectInstance mobEffectInstance;
    public final boolean showInInventory;
    public final boolean applyToSelf;
    public final int applyToNearby;
    public final int maxDistanceForEntities;
    public final int amountOfEntitiesToApplyTo;

    public MobEffectTrait(MobEffectInstance mobEffectInstance) {
        this(mobEffectInstance, false);
    }

    public MobEffectTrait(MobEffectInstance mobEffectInstance, boolean showInInventory) {
        this(mobEffectInstance, showInInventory, true, -1, -1, -1);
    }

    public MobEffectTrait(MobEffectInstance mobEffectInstance, boolean showInInventory, boolean applyToSelf, int applyToNearby, int maxDistanceForEntities, int amountOfEntitiesToApplyTo) {
        this.showInInventory = showInInventory;
        this.mobEffectInstance = mobEffectInstance;
        this.applyToSelf = applyToSelf;
        this.applyToNearby = applyToNearby;
        this.maxDistanceForEntities = maxDistanceForEntities;
        this.amountOfEntitiesToApplyTo = amountOfEntitiesToApplyTo;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean iconMightDiffer() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getIcon() {
        return Minecraft.getInstance().getMobEffectTextures().get(this.mobEffectInstance.getEffect());
    }
}

