/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.network.impl.SyncApiLevelPackets;
import tocraft.walkers.network.impl.UnlockPackets;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.SHAPE_SYNC, ClientNetworking::handleWalkersSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.SYNC_API_LEVEL, (context, nbt) -> SyncApiLevelPackets.handleSyncPacket(nbt));
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        ModernNetworking.sendToServer((class_2960)USE_ABILITY, (class_2487)new class_2487());
    }

    public static void handleWalkersSyncPacket(ModernNetworking.Context context, class_2487 packetData) {
        UUID uuid = packetData.method_25926("uuid");
        String id = packetData.method_10558("type");
        class_2487 entityNbt = packetData.method_10562("entity_tag");
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_5770().method_18470(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                    return;
                }
                entityNbt.method_10582("id", id);
                Optional type = class_1299.method_17684((class_2487)entityNbt);
                if (type.isPresent()) {
                    class_1309 shape = data.walkers$getCurrentShape();
                    if (shape == null || !((class_1299)type.get()).equals(shape.method_5864())) {
                        shape = (class_1309)((class_1299)type.get()).method_5883(CEntity.level((class_1297)syncTarget));
                        data.walkers$setCurrentShape(shape);
                        ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                    }
                    if (shape != null) {
                        shape.method_5651(entityNbt);
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(ModernNetworking.Context context, class_2487 packet) {
        int cooldown = packet.method_10550("cooldown");
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown));
    }
}

