/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.impl.tick.shapes.FrogTickHandler;
import tocraft.walkers.impl.tick.shapes.JumpBoostTickHandler;
import tocraft.walkers.impl.tick.shapes.SnowGolemTickHandler;
import tocraft.walkers.impl.tick.shapes.WardenTickHandler;

public class WalkersTickHandlers {
    private static final Map<EntityType<?>, WalkersTickHandler<?>> HANDLERS = new LinkedHashMap();

    @ApiStatus.Internal
    public static void initialize() {
        WalkersTickHandlers.register(EntityType.f_217015_, new WardenTickHandler());
        WalkersTickHandlers.register(EntityType.f_217012_, new FrogTickHandler());
        WalkersTickHandlers.register(EntityType.f_243976_, new JumpBoostTickHandler(0));
        WalkersTickHandlers.register(EntityType.f_20528_, new SnowGolemTickHandler());
        WalkersTickHandlers.register(EntityType.f_20517_, new JumpBoostTickHandler(1));
        WalkersTickHandlers.register(EntityType.f_147035_, new JumpBoostTickHandler(2));
        WalkersTickHandlers.register(EntityType.f_20468_, new JumpBoostTickHandler(2));
        WalkersTickHandlers.register(EntityType.f_20526_, new JumpBoostTickHandler(2));
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, WalkersTickHandler<T> handler) {
        HANDLERS.put(type, handler);
    }

    @ApiStatus.Internal
    public static Map<EntityType<?>, WalkersTickHandler<?>> getHandlers() {
        return HANDLERS;
    }
}

