/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.client;

import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={WolfRenderer.class})
public class WolfRendererMixin {
    @Unique
    private static final ResourceLocation SPECIAL_WILD = Walkers.id("textures/entity/wolf/special_wild.png");
    @Unique
    private static final ResourceLocation SPECIAL_TAMED = Walkers.id("textures/entity/wolf/special_tame.png");
    @Unique
    private static final ResourceLocation SPECIAL_ANGRY = Walkers.id("textures/entity/wolf/special_angry.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Wolf;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTexture(Wolf wolfEntity, CallbackInfoReturnable<ResourceLocation> ci) {
        CompoundTag nbt = new CompoundTag();
        wolfEntity.m_20240_(nbt);
        if (nbt.m_128441_("isSpecial") && nbt.m_128471_("isSpecial")) {
            if (wolfEntity.m_21824_()) {
                ci.setReturnValue((Object)SPECIAL_TAMED);
            } else {
                ci.setReturnValue((Object)(wolfEntity.m_21660_() ? SPECIAL_ANGRY : SPECIAL_WILD));
            }
        }
    }
}

