/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.abilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.GenericShapeAbility;
import tocraft.walkers.ability.ShapeAbility;

public class AbilityDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    public static final Codec<AbilityList> ABILITY_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(AbilityList::requiredMod), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList()).forGetter(AbilityList::entityTypeKeys), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList()).forGetter(AbilityList::entityTagKeys), (App)AbilityRegistry.getAbilityCodec().fieldOf("ability").forGetter(AbilityList::ability)).apply((Applicative)instance, instance.stable(AbilityList::new)));

    public AbilityDataManager() {
        super(GSON, "walkers/abilities");
    }

    protected void onApply(@NotNull Map<class_2960, JsonElement> map) {
        AbilityRegistry.clearAll();
        AbilityRegistry.registerDefault();
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            AbilityList abilityList = (AbilityList)ABILITY_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)mapEntry.getValue().getAsJsonObject()).getOrThrow(msg -> {
                throw new JsonParseException(msg);
            });
            if (abilityList.isEmpty() || abilityList.requiredMod() != null && !abilityList.requiredMod().isBlank() && !PlatformData.isModLoaded((String)abilityList.requiredMod())) continue;
            for (class_1299<class_1309> class_12992 : abilityList.entityTypes()) {
                AbilityRegistry.registerByType(class_12992, abilityList.ability());
            }
            if (!abilityList.entityTypes().isEmpty()) {
                AbilityDataManager.logRegistration(abilityList.entityTypes(), abilityList.ability());
            }
            for (class_6862 class_68622 : abilityList.entityTags()) {
                AbilityRegistry.registerByTag(class_68622, abilityList.ability());
            }
            if (abilityList.entityTags().isEmpty()) continue;
            AbilityDataManager.logRegistration(abilityList.entityTags(), abilityList.ability());
        }
    }

    private static void logRegistration(Object key, @NotNull ShapeAbility<?> ability) {
        Walkers.LOGGER.debug("{}: {} registered for {}", new Object[]{AbilityDataManager.class.getSimpleName(), ability.getClass().getSimpleName(), key});
    }

    public record AbilityList(String requiredMod, List<class_2960> entityTypeKeys, List<class_2960> entityTagKeys, GenericShapeAbility<?> ability) {
        public AbilityList(@NotNull List<class_1299<?>> entityTypeKeys, @NotNull List<class_6862<class_1299<?>>> entityTagKeys, GenericShapeAbility<?> ability, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(class_1299::method_5890).toList(), entityTagKeys.stream().map(class_6862::comp_327).toList(), ability);
        }

        public List<class_1299<class_1309>> entityTypes() {
            return this.entityTypeKeys.stream().filter(arg_0 -> ((class_7922)class_7923.field_41177).method_10250(arg_0)).map(type -> (class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(type).orElseThrow()).comp_349()).toList();
        }

        public List<class_6862<class_1299<?>>> entityTags() {
            return this.entityTagKeys().stream().map(tag -> class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tag)).toList();
        }

        public boolean isEmpty() {
            return this.entityTypeKeys().isEmpty() && this.entityTagKeys().isEmpty();
        }
    }
}

