/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.blacklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.walkers.api.blacklist.EntityBlacklist;

public class EntityBlacklistDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    public static final Codec<Pair<List<class_2960>, List<class_2960>>> BLACKLIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList()).forGetter(Pair::getFirst), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList()).forGetter(Pair::getSecond)).apply((Applicative)instance, instance.stable(Pair::new)));

    public EntityBlacklistDataManager() {
        super(GSON, "walkers");
    }

    protected void onApply(@NotNull Map<class_2960, JsonElement> map) {
        EntityBlacklist.clearAll();
        EntityBlacklist.registerDefault();
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            if (!mapEntry.getKey().method_12832().equals("blacklist")) continue;
            Pair<List<class_2960>, List<class_2960>> someBlacklist = EntityBlacklistDataManager.blacklistFromJson(mapEntry.getValue().getAsJsonObject());
            for (class_2960 resourceLocation : (List)someBlacklist.getFirst()) {
                if (!class_7923.field_41177.method_10250(resourceLocation)) continue;
                EntityBlacklist.registerByType((class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(resourceLocation).orElseThrow()).comp_349());
            }
            for (class_2960 resourceLocation : (List)someBlacklist.getSecond()) {
                EntityBlacklist.registerByTag(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)resourceLocation));
            }
        }
    }

    protected static Pair<List<class_2960>, List<class_2960>> blacklistFromJson(JsonObject json) {
        return (Pair)BLACKLIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
    }
}

