/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.annotions.Comment;
import tocraft.craftedcore.config.annotions.Synchronize;

public class WalkersConfig
implements Config {
    @Comment(value="Whether a player's equipped shape is revoked on death.")
    public boolean revoke2ndShapeOnDeath = false;
    @Comment(value="Whether shapes equip the items (swords, items, tools) held by the underlying player.")
    public boolean shapesEquipItems = true;
    @Comment(value="Whether shapes equip the armor (chestplate, leggings, elytra) worn by the underlying player.")
    public boolean shapesEquipArmor = true;
    @Comment(value="If true, the player can cause hostiles to attack via right-clicking.")
    public boolean playerCanTriggerHostiles = true;
    @Comment(value="Whether hostile mobs ignore players with hostile mob shapes.")
    public boolean hostilesIgnoreHostileShapedPlayer = true;
    @Comment(value="Whether hostile mobs ignore players, even if the player shapes into a not-hostile mob. Requires 'hostilesIgnoreHostileShapedPlayer' to be 'true'.")
    public boolean hostilesIgnoreNotHostileShapedPlayer = false;
    @Comment(value="Whether a hostile mob will stop targeting you after switching to a (hostile) mob shape.")
    public boolean hostilesForgetNewShapedPlayer = false;
    @Comment(value="hunterAttackAsPreyMorphedPlayer")
    public boolean hunterAttackAsPreyMorphedPlayer = true;
    @Comment(value="If false, the PreyTrait doesn't cause owned hunter (e.g. tamed wolves) to hunt the player.")
    public boolean ownedHunterAttackAsPreyMorphedPlayer = false;
    @Comment(value="Whether Villagers will run from Players morphed as shapes villagers normally run from (Zombies).")
    public boolean villagersRunFrom2ndShapes = true;
    @Comment(value="Whether shape sounds take priority over Player Sounds (e.g. Blaze hurt sound when hit).")
    public boolean useShapeSounds = true;
    @Comment(value="Whether disguised players should randomly emit the ambient sound of their shape.")
    public boolean playAmbientSounds = true;
    @Comment(value="Whether disguised players should hear their own ambient sounds (only if playAmbientSounds is true).")
    public boolean hearSelfAmbient = false;
    @Comment(value="Whether mobs in the flying entity tag can fly.")
    public boolean enableFlight = true;
    @Comment(value="How long hostility lasts for players morphed as hostile mobs (think: Pigman aggression)")
    public int hostilityTime = 300;
    @Comment(value="A list of Advancements required before the player can fly using a shape.")
    public List<String> advancementsRequiredForFlight = new ArrayList<String>();
    @Comment(value="Whether Shapes modify your max health value based on their max health value.")
    public boolean scalingHealth = true;
    @Comment(value="This gets the percentage of your current health and implements it into your new health. Only works with scalingHealth!")
    public boolean percentScalingHealth = true;
    @Comment(value="The maximum value of scaling health. Useful for not giving players 300 HP when they turn into a wither.")
    public int maxHealth = 40;
    @Comment(value="Whether the player should have the same default amor values as the mob.")
    public boolean scalingAmor = true;
    @Comment(value="The maximum value of default amor. Useful for not having players who can't take damage.")
    public int maxAmor = 30;
    @Comment(value="The maximum value of default amor toughness. Useful for not having players who can't take damage.")
    public int maxAmorToughness = 20;
    @Comment(value="Whether the player step height should be adjusted to the one of the mob.")
    public boolean scalingStepHeight = true;
    @Comment(value="In blocks, how far can the Enderman ability teleport?")
    public int endermanAbilityTeleportDistance = 32;
    @Comment(value="Should player nametags render above players disguised with a shape? Note that the server is the authority for this config option.")
    @Synchronize
    public boolean showPlayerNametag = false;
    @Comment(value="The default fly speed for transformed players.")
    public float flySpeed = 0.05f;
    @Comment(value="If true, players with the Warden shape will have a shorter view range with the darkness effect.")
    public boolean wardenIsBlinded = true;
    @Comment(value="If true, players with the Warden shape will blind other nearby players.")
    public boolean wardenBlindsNearby = true;
    @Comment(value="If true, unlocking a shape will ignore current second shapes.")
    @Synchronize
    public boolean unlockOverridesCurrentShape = false;
    @Comment(value="If true, unlocking a shape will ignore current second shapes.")
    @Synchronize
    public float unlockTimer = 60.0f;
    @Comment(value="This allows players to unlock every possible variant per entity type. This must be set to true for the variant menu to be available.")
    @Synchronize
    public boolean unlockEveryVariant = true;
    @Comment(value="Configure the Cooldown for the abilities of specified mobs. Take a look at Abilities")
    public Map<String, Integer> abilityCooldownMap = new HashMap<String, Integer>(){
        {
            this.put("minecraft:bee", 20);
            this.put("minecraft:blaze", 20);
            this.put("minecraft:camel", 40);
            this.put("minecraft:chicken", 1200);
            this.put("minecraft:cow", 20);
            this.put("minecraft:creeper", 100);
            this.put("minecraft:ender_dragon", 20);
            this.put("minecraft:enderman", 100);
            this.put("minecraft:endermite", 20);
            this.put("minecraft:evoker", 10);
            this.put("minecraft:ghast", 60);
            this.put("minecraft:goat", 20);
            this.put("minecraft:horse", 40);
            this.put("minecraft:illusioner", 2400);
            this.put("minecraft:iron_golem", 20);
            this.put("minecraft:llama", 20);
            this.put("minecraft:mooshroom", 300);
            this.put("minecraft:mule", 40);
            this.put("minecraft:pillager", 2400);
            this.put("minecraft:polar_bear", 20);
            this.put("minecraft:pufferfish", 20);
            this.put("minecraft:rabbit", 40);
            this.put("minecraft:ravager", 2400);
            this.put("minecraft:sheep", 20);
            this.put("minecraft:shulker", 80);
            this.put("minecraft:skeleton_horse", 40);
            this.put("minecraft:sniffer", 9600);
            this.put("minecraft:snow_golem", 10);
            this.put("minecraft:trader_llama", 20);
            this.put("minecraft:turtle", 6000);
            this.put("minecraft:vindicator", 2400);
            this.put("minecraft:warden", 200);
            this.put("minecraft:witch", 200);
            this.put("minecraft:wither", 200);
            this.put("minecraft:wolf", 20);
            this.put("minecraft:zombie_horse", 40);
            this.put("minecraft:zombified_piglin", 20);
        }
    };
    @Comment(value="0 - none, 1 - completely random, 2 - biome based")
    public int multiVectorVariants = 2;
    @Comment(value="Blacklist entity types (e.g. minecraft:blaze) to disable abilities for the specified mob.")
    @Synchronize
    public List<String> abilityBlacklist = new ArrayList<String>();
    @Comment(value="Map entity types to a list of traits to disable the traits for the specified entity type.")
    @Synchronize
    public Map<String, List<String>> traitBlacklist = new HashMap<String, List<String>>(){
        {
            this.put("example:my_mob", List.of("example:first_trait", "example:second_trait"));
        }
    };
    @Comment(value="Blacklist entity types (e.g. minecraft:blaze) to disable morphing into those.")
    @Synchronize
    public Set<String> entityBlacklist = new HashSet<String>();
    @Comment(value="True - the entity blacklist will be treated as a whitelist. This can be modified via commands.")
    @Synchronize
    public boolean entityBlacklistIsWhitelist = false;
    @Comment(value="Blacklist Players with their UUIDs, so they can't unlock shapes. This can be modified via commands.")
    @Synchronize
    public List<UUID> playerUUIDBlacklist = new ArrayList<UUID>();
    @Comment(value="True - the player blacklist will be treated as a whitelist. This can be modified via commands.")
    @Synchronize
    public boolean playerBlacklistIsWhitelist = false;
    @Comment(value="Whether the player blacklist should prevent unlocking.")
    @Synchronize
    public boolean blacklistPreventsUnlocking = true;
    @Comment(value="Whether the player blacklist should prevent morphing.")
    @Synchronize
    public boolean blacklistPreventsMorphing = true;
    @Comment(value="The health that a normal player should have (e.g. 20). Set to -1 to use a cached one or if you don't know what this option does")
    public float player_health = -1.0f;

    public String getName() {
        return "walkers";
    }
}

