/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10426;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.util.Maths;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.model.ArmRenderingManipulator;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.impl.ShapeRenderStateProvider;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.client.accessor.LimbAnimatorAccessor;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1007.class}, priority=1001)
public abstract class PlayerEntityRendererMixin
extends class_922<class_742, class_10055, class_591> {
    private PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_591 model, float shadowRadius) {
        super(ctx, (class_583)model, shadowRadius);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="RETURN")})
    private void onCreateState(class_742 player, class_10055 state, float f, CallbackInfo ci) {
        ((ShapeRenderStateProvider)state).walkers$setShape(() -> {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657)player);
            if (!class_310.method_1551().field_1690.method_31044().method_31034() || player.method_5854() != class_310.method_1551().field_1719) {
                if (shape != null) {
                    this.walkers$updateShapeAttributes(player, shape);
                }
                return shape;
            }
            return null;
        });
    }

    @Unique
    private void walkers$updateShapeAttributes(@NotNull class_10055 player, @NotNull class_10017 shape) {
        shape.field_53326 = player.field_53326;
        shape.field_53325 = player.field_53325;
        shape.field_53327 = player.field_53327;
        shape.field_53328 = player.field_53328;
        shape.field_53336 = player.field_53336;
        shape.field_53324 = player.field_53324;
        if (shape instanceof class_10042) {
            class_10042 livingState = (class_10042)shape;
            livingState.field_53465 = player.field_53465;
            livingState.field_53450 = player.field_53450;
            livingState.field_53451 = player.field_53451;
            livingState.field_53446 = player.field_53446;
            livingState.field_53448 = player.field_53448;
            livingState.field_53447 = player.field_53447;
            livingState.field_53452 = player.field_53452;
            livingState.field_53458 = player.field_53458;
            livingState.field_53453 = player.field_53453;
            if (livingState instanceof class_10426) {
                class_10426 armedState = (class_10426)livingState;
                armedState.field_55303 = player.field_55303;
            }
            if (shape instanceof class_10034) {
                class_10034 humanoidShape = (class_10034)shape;
                humanoidShape.field_53403 = player.field_53403;
                humanoidShape.field_53412 = player.field_53412;
                humanoidShape.field_53408 = player.field_53408;
                humanoidShape.field_53404 = player.field_53404;
                humanoidShape.field_53405 = player.field_53405;
                humanoidShape.field_53410 = player.field_53410;
                humanoidShape.field_53407 = player.field_53407;
                humanoidShape.field_53414 = player.field_53414;
            }
        }
    }

    @Unique
    private void walkers$updateShapeAttributes(@NotNull class_742 player, @NotNull class_1309 shape) {
        ((LimbAnimatorAccessor)shape.field_42108).setPrevSpeed(((LimbAnimatorAccessor)player.field_42108).getPrevSpeed());
        shape.field_42108.method_48567(player.field_42108.method_48566());
        ((LimbAnimatorAccessor)shape.field_42108).setPos(player.field_42108.method_48569());
        shape.field_6252 = player.field_6252;
        shape.field_6279 = player.field_6279;
        shape.field_6229 = player.field_6229;
        shape.field_6251 = player.field_6251;
        shape.field_6283 = player.field_6283;
        shape.field_6220 = player.field_6220;
        shape.field_6241 = player.field_6241;
        shape.field_6259 = player.field_6259;
        shape.field_6012 = player.field_6012;
        shape.field_6266 = player.field_6266;
        ((LivingEntityAccessor)shape).setSwimAmount(((LivingEntityAccessor)player).getSwimAmount());
        ((LivingEntityAccessor)shape).setSwimAmountO(((LivingEntityAccessor)player).getSwimAmountO());
        shape.method_24830(player.method_24828());
        shape.method_18799(player.method_18798());
        if (class_310.method_1551().field_1724 != null) {
            shape.method_5648(player.method_5756((class_1657)class_310.method_1551().field_1724));
        }
        ((EntityAccessor)shape).setVehicle(player.method_5854());
        ((EntityAccessor)shape).setPassengers((ImmutableList<class_1297>)ImmutableList.copyOf((Collection)player.method_5685()));
        ((EntityAccessor)shape).setTouchingWater(player.method_5799());
        if (shape instanceof class_1593) {
            shape.method_36457(-player.method_36455());
            shape.field_6004 = -player.field_6004;
        } else {
            shape.method_36457(player.method_36455());
            shape.field_6004 = player.field_6004;
        }
        if (Walkers.CONFIG.shapesEquipItems) {
            shape.method_5673(class_1304.field_6173, player.method_6118(class_1304.field_6173));
            shape.method_5673(class_1304.field_6171, player.method_6118(class_1304.field_6171));
        }
        if (Walkers.CONFIG.shapesEquipArmor) {
            shape.method_5673(class_1304.field_6169, player.method_6118(class_1304.field_6169));
            shape.method_5673(class_1304.field_6174, player.method_6118(class_1304.field_6174));
            shape.method_5673(class_1304.field_6172, player.method_6118(class_1304.field_6172));
            shape.method_5673(class_1304.field_6166, player.method_6118(class_1304.field_6166));
        }
        if (shape instanceof class_1308) {
            ((class_1308)shape).method_19540(player.method_6115());
        }
        shape.method_18380(player.method_18376());
        shape.method_6019(player.method_6058() == null ? class_1268.field_5808 : player.method_6058());
        ((LivingEntityAccessor)shape).callSetLivingEntityFlag(1, player.method_6115());
        shape.method_6048();
        ((LivingEntityAccessor)shape).callUpdatingUsingItem();
        shape.field_6235 = player.field_6235;
        EntityUpdater entityUpdater = EntityUpdaters.getUpdater(shape.method_5864());
        if (entityUpdater != null) {
            entityUpdater.update((class_1657)player, shape);
        }
        if (player != class_310.method_1551().field_1724 && PlayerEntityRendererMixin.walkers$showName(player)) {
            shape.method_5665(player.method_5797());
        }
    }

    @Unique
    private static boolean walkers$showName(@NotNull class_742 player) {
        class_268 team = player.method_5781();
        boolean showName = Walkers.CONFIG.showPlayerNametag;
        if (showName && team != null) {
            class_270.class_272 visibility = team.method_1201();
            class_268 localTeam = class_310.method_1551().field_1724.method_5781();
            boolean sameTeam = Objects.equals(localTeam != null ? localTeam.method_1197() : null, team.method_1197());
            if (visibility == class_270.class_272.field_1443 || sameTeam && visibility == class_270.class_272.field_1446 || !sameTeam && visibility == class_270.class_272.field_1444) {
                showName = false;
            }
        }
        return showName;
    }

    public void render(class_10055 state, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        class_1309 shape = ((ShapeRenderStateProvider)state).walkers$getShape();
        if (shape != null && !state.field_53542) {
            if (!state.field_53461 && !state.field_53333) {
                class_897 shapeRenderer = class_310.method_1551().method_1561().method_3953((class_1297)shape);
                class_10017 shapeState = shapeRenderer.method_62425((class_1297)shape, (float)packedLight);
                this.walkers$updateShapeAttributes(state, shapeState);
                shapeRenderer.method_3936(shapeState, matrixStack, buffer, packedLight);
            }
            return;
        }
        super.method_4054((class_10042)state, matrixStack, buffer, packedLight);
    }

    @Inject(method={"getRenderOffset(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPositionOffset(class_10055 state, CallbackInfoReturnable<class_243> cir) {
        class_1309 shape = ((ShapeRenderStateProvider)state).walkers$getShape();
        if (shape != null && shape instanceof class_1321) {
            cir.setReturnValue((Object)super.method_23169((class_10017)state));
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_2960 resourceLocation, class_630 arm, boolean bl, CallbackInfo ci) {
        class_897 renderer;
        class_1657 player;
        class_1309 shape;
        class_1297 class_12972 = class_310.method_1551().field_1719;
        if (class_12972 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_12972)) != null && (renderer = class_310.method_1551().method_1561().method_3953((class_1297)shape)) instanceof class_922) {
            class_922 livingRenderer = (class_922)renderer;
            class_10042 shapeState = (class_10042)livingRenderer.method_62425((class_1297)shape, (float)light);
            class_2960 texture = livingRenderer.method_3885(shapeState);
            class_583 model = livingRenderer.method_4038();
            arm = null;
            if (model instanceof class_572) {
                arm = player.method_6068() == class_1306.field_6183 ? ((class_572)model).field_3401 : ((class_572)model).field_27433;
            } else {
                class_3545<class_630, ArmRenderingManipulator<?>> pair = EntityArms.get(shape, model);
                if (pair != null) {
                    arm = (class_630)pair.method_15442();
                    if (player.method_6068() == class_1306.field_6182) {
                        matrices.method_22907(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)180.0f));
                    }
                    ((ArmRenderingManipulator)pair.method_15441()).run(matrices, model);
                    matrices.method_22904(0.0, -0.35, 0.5);
                }
            }
            model.method_2819(renderer.method_62425((class_1297)shape, (float)light));
            if (arm != null) {
                arm.field_3654 = 0.0f;
                arm.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture)), light, class_4608.field_21444);
            }
            ci.cancel();
        }
    }
}

