/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network.impl;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class UnlockPackets {
    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(ModernNetworking.Context context, class_2487 nbt) {
        if (nbt != null && ApiLevel.getCurrentLevel().canUnlock) {
            class_2487 idTag = nbt.method_10562(UNLOCK_KEY);
            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.method_33133()) {
                    ((PlayerDataProvider)player).walkers$set2ndShape(ShapeType.from(idTag));
                }
            });
        }
    }

    public static void registerShapeUnlockRequestPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)NetworkHandler.UNLOCK_REQUEST, (context, nbt) -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().method_5667()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
                return;
            }
            if (!ApiLevel.getCurrentLevel().canUnlock) {
                return;
            }
            boolean validType = nbt.method_10577("valid_type");
            if (validType) {
                class_2960 typeId = class_2960.method_60654((String)nbt.method_10558("type_id"));
                class_1299 entityType = (class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(typeId).orElseThrow()).comp_349();
                int variant = nbt.method_10550("variant");
                context.getPlayer().method_5682().execute(() -> {
                    boolean result;
                    @Nullable ShapeType<Z> type = ShapeType.from(entityType, variant);
                    if (type != null && !EntityBlacklist.isBlacklisted(type.getEntityType()) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape() == null) && (result = PlayerShapeChanger.change2ndShape((class_3222)context.getPlayer(), type))) {
                        PlayerShape.updateShapes((class_3222)context.getPlayer(), type.create(context.getPlayer().method_37908(), context.getPlayer()));
                    }
                });
            } else {
                context.getPlayer().method_5682().execute(() -> PlayerShape.updateShapes((class_3222)context.getPlayer(), null));
            }
            context.getPlayer().method_18382();
        });
    }

    public static void sendSyncPacket(class_3222 player) {
        class_2487 compound = new class_2487();
        class_2487 id = new class_2487();
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            id = ((PlayerDataProvider)player).walkers$get2ndShape().writeCompound();
        }
        compound.method_10566(UNLOCK_KEY, (class_2520)id);
        ModernNetworking.sendToPlayer((class_3222)player, (class_2960)NetworkHandler.UNLOCK_SYNC, (class_2487)compound);
    }

    public static void sendUnlockRequest(@Nullable ShapeType<? extends class_1309> type) {
        class_2487 packet = new class_2487();
        packet.method_10556("valid_type", type != null);
        if (type != null) {
            packet.method_10582("type_id", class_1299.method_5890(type.getEntityType()).toString());
            packet.method_10569("variant", type.getVariantData());
        }
        ModernNetworking.sendToServer((class_2960)ClientNetworking.UNLOCK_REQUEST, (class_2487)packet);
    }
}

