/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers;

import dev.tocraft.craftedcore.config.Config;
import dev.tocraft.craftedcore.config.ConfigLoader;
import dev.tocraft.craftedcore.event.common.EntityEvents;
import dev.tocraft.craftedcore.event.common.PlayerEvents;
import dev.tocraft.craftedcore.event.common.ServerLevelEvents;
import dev.tocraft.craftedcore.platform.VersionChecker;
import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.WalkersTickHandlers;
import dev.tocraft.walkers.api.data.DataManager;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.platform.WalkersConfig;
import dev.tocraft.walkers.command.WalkersCommand;
import dev.tocraft.walkers.eventhandler.LivingBreatheHandler;
import dev.tocraft.walkers.eventhandler.RespawnHandler;
import dev.tocraft.walkers.eventhandler.WalkersEventHandlers;
import dev.tocraft.walkers.integrations.Integrations;
import dev.tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import dev.tocraft.walkers.network.ServerNetworking;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.FlyingTrait;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Walkers {
    public static ProblemReporter PROBLEM_REPORTER = new ProblemReporter(){

        @Contract(pure=true)
        @NotNull
        public ProblemReporter forChild(ProblemReporter.PathElement pathElement) {
            return this;
        }

        public void report(@NotNull ProblemReporter.Problem problem) {
            LOGGER.error(problem.description());
        }
    };
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(Walkers.class);
    public static final String MODID = "walkers";
    public static final WalkersConfig CONFIG = (WalkersConfig)ConfigLoader.register((String)"walkers", (Config[])new WalkersConfig[0]);
    @ApiStatus.Internal
    public static final List<UUID> devs = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("1f63e38e-4059-4a4f-b7c4-0fac4a48e744"));
            this.add(UUID.fromString("494e1c8a-f733-43ed-8c1b-a2943fdc05f3"));
            this.add(UUID.fromString("eb83f5a3-397a-4e14-80bc-914ff91890f0"));
            this.add(UUID.fromString("17eae0aa-e445-489a-92ae-697d0a9d5731"));
            this.add(UUID.fromString("53430a02-dbd1-4b5c-9984-4119e38fec79"));
            this.add(UUID.fromString("50ee913f-a7d6-45ea-8d09-45fb3726aec1"));
            this.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
            this.add(UUID.fromString("d4a50582-c44e-4a0d-ab0c-9711e2cf4b29"));
            this.add(UUID.fromString("ccddb138-0b29-493f-9d27-0f51ed3a0578"));
        }
    };

    public void initialize() {
        Integrations.initIntegrations();
        TraitRegistry.initialize();
        AbilityRegistry.initialize();
        WalkersCommand.initialize();
        WalkersEventHandlers.initialize();
        ServerNetworking.initialize();
        Walkers.registerJoinSyncPacket();
        WalkersTickHandlers.initialize();
        DataManager.initialize();
        Integrations.initialize();
        PlayerEvents.PLAYER_RESPAWN.register((Object)new RespawnHandler());
        EntityEvents.LIVING_BREATHE.register((Object)new LivingBreatheHandler());
        ServerLevelEvents.LEVEL_LOAD.register(level -> ApiLevel.readConfig());
    }

    public static void registerJoinSyncPacket() {
        VersionChecker.registerModrinthChecker((String)MODID, (String)"woodwalkers", (Component)Component.literal((String)"Woodwalkers"));
        PlayerEvents.PLAYER_JOIN.register(player -> {
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)player.level().getChunkSource().chunkMap).getEntityMap();
            trackers.forEach((entityid, tracking) -> {
                if (player.level().getEntity(entityid.intValue()) instanceof ServerPlayer) {
                    PlayerShape.sync((ServerPlayer)player.level().getEntity(entityid.intValue()), player);
                }
            });
        });
    }

    @NotNull
    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public static boolean hasFlyingPermissions(@NotNull ServerPlayer player) {
        return Walkers.hasFlyingPermissions(player, player.gameMode.getGameModeForPlayer());
    }

    public static boolean hasFlyingPermissions(@NotNull ServerPlayer player, @NotNull GameType gameMode) {
        if (gameMode.isCreative()) {
            return true;
        }
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && Walkers.CONFIG.enableFlight && (TraitRegistry.has(shape, FlyingTrait.ID) || shape instanceof FlyingAnimal)) {
            List<String> requiredAdvancements = Walkers.CONFIG.advancementsRequiredForFlight;
            if (!requiredAdvancements.isEmpty()) {
                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    AdvancementProgress progress;
                    AdvancementHolder advancement = Optional.ofNullable(player.getServer()).flatMap(s -> Optional.of(s.getAdvancements())).map(a -> a.get(ResourceLocation.parse((String)requiredAdvancement))).orElse(null);
                    if (advancement == null || (progress = player.getAdvancements().getOrStartProgress(advancement)).isDone()) continue;
                    hasPermission = false;
                }
                return hasPermission;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlayerBlacklisted(UUID uuid) {
        return Walkers.CONFIG.playerBlacklistIsWhitelist != Walkers.CONFIG.playerUUIDBlacklist.contains(uuid);
    }

    public static boolean hasSpecialShape(UUID uuid) {
        return devs.contains(uuid);
    }
}

