/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers;

import com.mojang.blaze3d.platform.InputConstants;
import dev.tocraft.craftedcore.event.client.ClientPlayerEvents;
import dev.tocraft.craftedcore.event.client.ClientTickEvents;
import dev.tocraft.craftedcore.event.client.RenderEvents;
import dev.tocraft.craftedcore.registration.KeyBindingRegistry;
import dev.tocraft.walkers.ability.AbilityOverlayRenderer;
import dev.tocraft.walkers.api.model.EntityArms;
import dev.tocraft.walkers.api.model.EntityUpdaters;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.eventhandler.ClientRespawnHandler;
import dev.tocraft.walkers.impl.tick.KeyPressHandler;
import dev.tocraft.walkers.network.ClientNetworking;
import dev.tocraft.walkers.screen.hud.OverlayEventHandler;
import dev.tocraft.walkers.screen.hud.VariantMenu;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class WalkersClient {
    public static boolean isRenderingVariantsMenu = false;
    @ApiStatus.Internal
    public static int variantOffset = 0;
    public static final KeyMapping UNLOCK_KEY = new KeyMapping("key.walkers_unlock", InputConstants.Type.KEYSYM, 85, "key.categories.walkers");
    public static final KeyMapping TRANSFORM_KEY = new KeyMapping("key.walkers", InputConstants.Type.KEYSYM, 71, "key.categories.walkers");
    public static final KeyMapping ABILITY_KEY = new KeyMapping("key.walkers_ability", InputConstants.Type.KEYSYM, 82, "key.categories.walkers");
    public static final KeyMapping VARIANTS_MENU_KEY = new KeyMapping("key.walkers_variants", InputConstants.Type.KEYSYM, 86, "key.categories.walkers");

    public void initialize() {
        KeyBindingRegistry.register((KeyMapping)ABILITY_KEY);
        KeyBindingRegistry.register((KeyMapping)TRANSFORM_KEY);
        KeyBindingRegistry.register((KeyMapping)UNLOCK_KEY);
        KeyBindingRegistry.register((KeyMapping)VARIANTS_MENU_KEY);
        EntityUpdaters.init();
        AbilityOverlayRenderer.register();
        EntityArms.init();
        ClientTickEvents.CLIENT_PRE.register((Object)new KeyPressHandler());
        RenderEvents.HUD_RENDERING.register((Object)new VariantMenu());
        ClientNetworking.registerPacketHandlers();
        OverlayEventHandler.initialize();
        ClientPlayerEvents.CLIENT_PLAYER_RESPAWN.register((Object)new ClientRespawnHandler());
        ClientPlayerEvents.CLIENT_PLAYER_QUIT.register(player -> {
            if (player != null && ApiLevel.getClientLevel() != null) {
                ((ApiLevel.OnApiLevelChange)ApiLevel.ON_API_LEVEL_CHANGE_EVENT.invoke()).onApiLevelChange(ApiLevel.getClientLevel());
            }
        });
    }
}

