/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability;

import dev.tocraft.craftedcore.event.client.RenderEvents;
import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.ability.ShapeAbility;
import dev.tocraft.walkers.api.PlayerAbilities;
import dev.tocraft.walkers.api.PlayerShape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AbilityOverlayRenderer {
    public static void register() {
        RenderEvents.HUD_RENDERING.register((graphics, delta) -> {
            Item icon;
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
            if (shape == null) {
                return;
            }
            ShapeAbility<LivingEntity> shapeAbility = AbilityRegistry.get(shape);
            if (player != null && shapeAbility != null && (icon = shapeAbility.getIcon()) != null) {
                int currentCooldown = PlayerAbilities.getCooldown((Player)player);
                int maxCooldown = shapeAbility.getCooldown(shape);
                if (client.screen instanceof ChatScreen || currentCooldown <= 0) {
                    return;
                }
                double d = client.getWindow().getGuiScale();
                float cooldownScale = 1.0f - (float)currentCooldown / (float)maxCooldown;
                if (client.player != null) {
                    int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                    int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                    int itemX = (int)((float)width * 0.95f);
                    int itemY = (int)((float)height * 0.92f);
                    int itemSize = 16;
                    graphics.pose().pushMatrix();
                    if (cooldownScale != 1.0f) {
                        int visibleHeight = (int)((float)itemSize * cooldownScale);
                        graphics.enableScissor(itemX, itemY + visibleHeight, itemX + itemSize, itemY + itemSize);
                    }
                    ItemStack stack = new ItemStack((ItemLike)icon);
                    graphics.renderItem(stack, (int)((float)width * 0.95f), (int)((float)height * 0.92f));
                    if (cooldownScale != 1.0f) {
                        graphics.disableScissor();
                    }
                    graphics.pose().popMatrix();
                }
            }
        });
    }
}

