/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability;

import dev.tocraft.walkers.Walkers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public abstract class ShapeAbility<E extends LivingEntity> {
    public abstract ResourceLocation getId();

    public abstract void onUse(ServerPlayer var1, E var2, ServerLevel var3);

    public int getCooldown(@NotNull E entity) {
        String id = EntityType.getKey((EntityType)entity.getType()).toString();
        if (!entity.level().isClientSide() && !Walkers.CONFIG.abilityCooldownMap.containsKey(id)) {
            Walkers.CONFIG.abilityCooldownMap.put(id, this.getDefaultCooldown());
            Walkers.CONFIG.save();
        }
        return Walkers.CONFIG.abilityCooldownMap.getOrDefault(id, this.getDefaultCooldown());
    }

    public int getDefaultCooldown() {
        return 20;
    }

    public abstract Item getIcon();
}

