/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.GenericShapeAbility;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GetItemAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    private final ItemStack itemStack;
    public static final ResourceLocation ID = Walkers.id("get_item");
    public static final MapCodec<GetItemAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(o -> BuiltInRegistries.ITEM.getKey((Object)o.itemStack.getItem())), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(o -> o.itemStack.getCount())).apply((Applicative)instance, instance.stable((item, amount) -> new GetItemAbility(new ItemStack((ItemLike)((Holder.Reference)BuiltInRegistries.ITEM.get(item).orElseThrow()).value(), amount.intValue())))));

    public GetItemAbility(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void onUse(ServerPlayer player, T shape, ServerLevel world) {
        player.getInventory().add(this.itemStack);
    }

    @Override
    public Item getIcon() {
        return this.itemStack.getItem();
    }

    @Override
    public int getDefaultCooldown() {
        return 600;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}

