/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.specific;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.ShapeAbility;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BreezeAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("breeze");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(ServerPlayer player, T shape, ServerLevel world) {
        if (player.isShiftKeyDown()) {
            player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, this.getCooldown(shape), 5, true, false));
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BREEZE_JUMP, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            Projectile.spawnProjectileFromRotation((serverLevelx, livingEntity, itemStackx) -> new WindCharge((Player)player, (Level)world, player.position().x(), player.getEyePosition().y(), player.position().z()), (ServerLevel)world, (ItemStack)new ItemStack((ItemLike)Items.WIND_CHARGE), (LivingEntity)player, (float)0.0f, (float)WindChargeItem.PROJECTILE_SHOOT_POWER, (float)1.0f);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        }
    }

    @Override
    public Item getIcon() {
        return Items.WIND_CHARGE;
    }

    @Override
    public int getDefaultCooldown() {
        return 60;
    }
}

