/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.specific;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.ShapeAbility;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GuardianAbility<T extends Guardian>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("guardian");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(@NotNull ServerPlayer player, @NotNull T shape, @NotNull ServerLevel world) {
        int beamLength = 10;
        int particleFreq = 5;
        Vec3 lookVec = player.getForward().normalize();
        for (int i = 0; i <= beamLength * particleFreq; ++i) {
            Vec3 beamPos = player.getEyePosition(1.0f).add(lookVec.scale((double)i / (double)particleFreq));
            world.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, beamPos.x, beamPos.y, beamPos.z, 0, 0.0, 0.0, 0.0, 0.0);
        }
        player.playSound(SoundEvents.GUARDIAN_ATTACK, 1.0f, 1.5f);
        if (player.isInWater()) {
            AABB box = new AABB(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(lookVec.scale((double)beamLength)));
            List entitiesInBeam = world.getEntitiesOfClass(LivingEntity.class, box);
            for (LivingEntity entity : entitiesInBeam) {
                if (entity == player) continue;
                entity.hurtServer(world, world.damageSources().indirectMagic((Entity)player, (Entity)player), 5.0f);
                player.doHurtTarget(world, (Entity)entity);
            }
        }
    }

    @Override
    public Item getIcon() {
        return Items.HEART_OF_THE_SEA;
    }

    @Override
    public int getDefaultCooldown() {
        return 160;
    }
}

