/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.specific;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.ShapeAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RabbitAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("rabbit");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(ServerPlayer player, T shape, ServerLevel world) {
        if (!world.isClientSide()) {
            BlockPos blockPos = player.blockPosition().above();
            BlockState blockState = world.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block instanceof CarrotBlock) {
                int i = (Integer)blockState.getValue((Property)CarrotBlock.AGE);
                if (i == 0) {
                    world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
                    world.destroyBlock(blockPos, true, (Entity)player);
                } else {
                    world.setBlock(blockPos, (BlockState)blockState.setValue((Property)CarrotBlock.AGE, (Comparable)Integer.valueOf(i - 1)), 2);
                    world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                    world.levelEvent((Entity)player, 2001, blockPos, Block.getId((BlockState)blockState));
                    player.gameEvent((Holder)GameEvent.EAT);
                    player.getFoodData().eat(1, 0.1f);
                }
            }
            world.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.RABBIT_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public int getDefaultCooldown() {
        return 40;
    }

    @Override
    public Item getIcon() {
        return Items.CARROT;
    }
}

