/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.specific;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.ShapeAbility;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SnifferAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("sniffer");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(ServerPlayer player, T shape, ServerLevel world) {
        if (player.isInLava() || player.isInWater() || !player.onGround()) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        BlockPos blockPos = new BlockPos(playerPos.getX(), playerPos.getY() - 1, playerPos.getZ());
        ArrayList<Block> diggableBlocks = new ArrayList<Block>();
        diggableBlocks.add(Blocks.DIRT);
        diggableBlocks.add(Blocks.GRASS_BLOCK);
        diggableBlocks.add(Blocks.PODZOL);
        diggableBlocks.add(Blocks.ROOTED_DIRT);
        diggableBlocks.add(Blocks.MOSS_BLOCK);
        diggableBlocks.add(Blocks.MUD);
        diggableBlocks.add(Blocks.MUDDY_MANGROVE_ROOTS);
        if (diggableBlocks.contains(world.getBlockState(blockPos).getBlock()) && Math.random() <= 0.5) {
            if (SnifferAbility.getRandomBoolean()) {
                player.spawnAtLocation(world, (ItemLike)Items.TORCHFLOWER_SEEDS);
            } else {
                player.spawnAtLocation(world, (ItemLike)Items.PITCHER_POD);
            }
            world.playSound(null, (Entity)player, SoundEvents.SNIFFER_DIGGING, SoundSource.PLAYERS, 1.0f, (world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f);
        } else {
            world.playSound(null, (Entity)player, SoundEvents.SNIFFER_DIGGING_STOP, SoundSource.PLAYERS, 1.0f, (world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public Item getIcon() {
        return Items.TORCHFLOWER;
    }

    private static boolean getRandomBoolean() {
        return Math.random() < 0.5;
    }

    @Override
    public int getDefaultCooldown() {
        return 9600;
    }
}

