/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability.impl.specific;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.ShapeAbility;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WitherAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("wither");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(ServerPlayer player, T shape, ServerLevel world) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITHER_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            Vec3 lookDirection = player.getLookAngle();
            WitherSkull skull = new WitherSkull((Level)world, (LivingEntity)player, new Vec3(lookDirection.x, lookDirection.y, lookDirection.z));
            skull.setPosRaw(player.getX(), player.getY() + 2.0, player.getZ());
            skull.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)skull);
        }
    }

    @Override
    public Item getIcon() {
        return Items.WITHER_SKELETON_SKULL;
    }

    @Override
    public int getDefaultCooldown() {
        return 200;
    }
}

