/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api;

import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.ability.ShapeAbility;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.events.ShapeEvents;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerAbilities {
    public static int getCooldown(Player player) {
        return ((PlayerDataProvider)player).walkers$getAbilityCooldown();
    }

    public static boolean canUseAbility(@NotNull Player player) {
        return !player.isSpectator() && ((PlayerDataProvider)player).walkers$getAbilityCooldown() <= 0;
    }

    public static void setCooldown(Player player, int cooldown) {
        ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown);
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer player) {
        CompoundTag packet = new CompoundTag();
        packet.putInt("cooldown", ((PlayerDataProvider)player).walkers$getAbilityCooldown());
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.ABILITY_SYNC, (CompoundTag)packet);
    }

    public static void useAbility(ServerPlayer player) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && AbilityRegistry.has(shape) && PlayerAbilities.canUseAbility((Player)player)) {
            ShapeAbility<LivingEntity> ability = AbilityRegistry.get(shape);
            if (ability == null) {
                return;
            }
            InteractionResult result = ((ShapeEvents.UseShapeAbilityCallback)ShapeEvents.USE_SHAPE_ABILITY.invoke()).use((Player)player, ability);
            if (result == InteractionResult.FAIL) {
                return;
            }
            ability.onUse(player, shape, player.level());
            PlayerAbilities.setCooldown((Player)player, ability.getCooldown(shape));
            PlayerAbilities.sync(player);
        }
    }
}

