/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api;

import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.blacklist.EntityBlacklist;
import dev.tocraft.walkers.api.events.ShapeEvents;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.NetworkHandler;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PlayerShape {
    @Nullable
    public static LivingEntity getCurrentShape(Player player) {
        return ((PlayerDataProvider)player).walkers$getCurrentShape();
    }

    public static boolean updateShapes(ServerPlayer player, @Nullable LivingEntity entity) {
        if (entity != null && EntityBlacklist.isBlacklisted(entity.getType())) {
            return false;
        }
        InteractionResult result = ((ShapeEvents.ShapeSwapCallback)ShapeEvents.SWAP_SHAPE.invoke()).swap(player, entity);
        if (result == InteractionResult.FAIL) {
            return false;
        }
        ((PlayerDataProvider)player).walkers$updateShapes(entity);
        return true;
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer player) {
        PlayerShape.sync(player, player);
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        CompoundTag data = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        LivingEntity shape = PlayerShape.getCurrentShape((Player)changed);
        if (shape != null) {
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)changed.registryAccess());
            shape.saveWithoutId((ValueOutput)out);
            entityTag = out.buildResult();
        }
        data.putIntArray("uuid", UUIDUtil.uuidToIntArray((UUID)changed.getUUID()));
        data.putString("type", shape == null ? "minecraft:empty" : EntityType.getKey((EntityType)shape.getType()).toString());
        data.put("entity_tag", (Tag)entityTag);
        ModernNetworking.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.SHAPE_SYNC, (CompoundTag)data);
    }
}

