/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api;

import dev.tocraft.walkers.api.WalkersTickHandler;
import dev.tocraft.walkers.impl.tick.shapes.FrogTickHandler;
import dev.tocraft.walkers.impl.tick.shapes.JumpBoostTickHandler;
import dev.tocraft.walkers.impl.tick.shapes.SnowGolemTickHandler;
import dev.tocraft.walkers.impl.tick.shapes.WardenTickHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;

public class WalkersTickHandlers {
    private static final Map<EntityType<?>, WalkersTickHandler<?>> HANDLERS = new LinkedHashMap();

    @ApiStatus.Internal
    public static void initialize() {
        WalkersTickHandlers.register(EntityType.WARDEN, new WardenTickHandler());
        WalkersTickHandlers.register(EntityType.FROG, new FrogTickHandler());
        WalkersTickHandlers.register(EntityType.CAMEL, new JumpBoostTickHandler(0));
        WalkersTickHandlers.register(EntityType.SNOW_GOLEM, new SnowGolemTickHandler());
        WalkersTickHandlers.register(EntityType.RABBIT, new JumpBoostTickHandler(1));
        WalkersTickHandlers.register(EntityType.GOAT, new JumpBoostTickHandler(0));
        WalkersTickHandlers.register(EntityType.MAGMA_CUBE, new JumpBoostTickHandler(2));
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, WalkersTickHandler<T> handler) {
        HANDLERS.put(type, handler);
    }

    @ApiStatus.Internal
    public static Map<EntityType<?>, WalkersTickHandler<?>> getHandlers() {
        return HANDLERS;
    }
}

