/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.blacklist;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.integrations.Integrations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;

public class EntityBlacklist {
    private static final List<EntityType<?>> typeBlacklist = new ArrayList();
    private static final List<TagKey<EntityType<?>>> tagBlacklist = new ArrayList();

    @ApiStatus.Internal
    public static void registerDefault() {
        EntityBlacklist.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("blacklisted")));
        Integrations.registerEntityBlacklist();
    }

    public static boolean isBlacklisted(EntityType<?> entityType) {
        if (typeBlacklist.contains(entityType)) {
            return true;
        }
        for (TagKey<EntityType<?>> entityTypeTagKey : tagBlacklist) {
            if (!entityType.is(entityTypeTagKey)) continue;
            return true;
        }
        return Walkers.CONFIG.entityBlacklistIsWhitelist != Walkers.CONFIG.entityBlacklist.contains(EntityType.getKey(entityType).toString());
    }

    public static void registerByType(EntityType<?> entityType) {
        if (!typeBlacklist.contains(entityType)) {
            typeBlacklist.add(entityType);
        }
    }

    public static void registerByTag(TagKey<EntityType<?>> entityTypeTag) {
        if (!tagBlacklist.contains(entityTypeTag)) {
            tagBlacklist.add(entityTypeTag);
        }
    }

    @ApiStatus.Internal
    public static void clearAll() {
        typeBlacklist.clear();
        tagBlacklist.clear();
    }
}

