/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.data.abilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.ability.GenericShapeAbility;
import dev.tocraft.walkers.ability.ShapeAbility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class AbilityDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Codec<AbilityList> ABILITY_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(AbilityList::requiredMod), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_types", new ArrayList()).forGetter(AbilityList::entityTypeKeys), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_tags", new ArrayList()).forGetter(AbilityList::entityTagKeys), (App)AbilityRegistry.getAbilityCodec().fieldOf("ability").forGetter(AbilityList::ability)).apply((Applicative)instance, instance.stable(AbilityList::new)));

    public AbilityDataManager() {
        super(GSON, "walkers/abilities");
    }

    protected void onApply(@NotNull Map<ResourceLocation, JsonElement> map) {
        AbilityRegistry.clearAll();
        AbilityRegistry.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            AbilityList abilityList = (AbilityList)ABILITY_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)mapEntry.getValue().getAsJsonObject()).getOrThrow(msg -> {
                throw new JsonParseException(msg);
            });
            if (abilityList.isEmpty() || abilityList.requiredMod() != null && !abilityList.requiredMod().isBlank() && !PlatformData.isModLoaded((String)abilityList.requiredMod())) continue;
            for (EntityType<LivingEntity> entityType : abilityList.entityTypes()) {
                AbilityRegistry.registerByType(entityType, abilityList.ability());
            }
            if (!abilityList.entityTypes().isEmpty()) {
                AbilityDataManager.logRegistration(abilityList.entityTypes(), abilityList.ability());
            }
            for (TagKey tagKey : abilityList.entityTags()) {
                AbilityRegistry.registerByTag(tagKey, abilityList.ability());
            }
            if (abilityList.entityTags().isEmpty()) continue;
            AbilityDataManager.logRegistration(abilityList.entityTags(), abilityList.ability());
        }
    }

    private static void logRegistration(Object key, @NotNull ShapeAbility<?> ability) {
        Walkers.LOGGER.debug("{}: {} registered for {}", new Object[]{AbilityDataManager.class.getSimpleName(), ability.getClass().getSimpleName(), key});
    }

    public record AbilityList(String requiredMod, List<ResourceLocation> entityTypeKeys, List<ResourceLocation> entityTagKeys, GenericShapeAbility<?> ability) {
        public AbilityList(@NotNull List<EntityType<?>> entityTypeKeys, @NotNull List<TagKey<EntityType<?>>> entityTagKeys, GenericShapeAbility<?> ability, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(EntityType::getKey).toList(), entityTagKeys.stream().map(TagKey::location).toList(), ability);
        }

        public List<EntityType<LivingEntity>> entityTypes() {
            return this.entityTypeKeys.stream().filter(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).containsKey(arg_0)).map(type -> (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(type).orElseThrow()).value()).toList();
        }

        public List<TagKey<EntityType<?>>> entityTags() {
            return this.entityTagKeys().stream().map(tag -> TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)tag)).toList();
        }

        public boolean isEmpty() {
            return this.entityTypeKeys().isEmpty() && this.entityTagKeys().isEmpty();
        }
    }
}

