/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.data.blacklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import dev.tocraft.walkers.api.blacklist.EntityBlacklist;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class EntityBlacklistDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Codec<Pair<List<ResourceLocation>, List<ResourceLocation>>> BLACKLIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_types", new ArrayList()).forGetter(Pair::getFirst), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_tags", new ArrayList()).forGetter(Pair::getSecond)).apply((Applicative)instance, instance.stable(Pair::new)));

    public EntityBlacklistDataManager() {
        super(GSON, "walkers");
    }

    protected void onApply(@NotNull Map<ResourceLocation, JsonElement> map) {
        EntityBlacklist.clearAll();
        EntityBlacklist.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            if (!mapEntry.getKey().getPath().equals("blacklist")) continue;
            Pair<List<ResourceLocation>, List<ResourceLocation>> someBlacklist = EntityBlacklistDataManager.blacklistFromJson(mapEntry.getValue().getAsJsonObject());
            for (ResourceLocation resourceLocation : (List)someBlacklist.getFirst()) {
                if (!BuiltInRegistries.ENTITY_TYPE.containsKey(resourceLocation)) continue;
                EntityBlacklist.registerByType((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).orElseThrow()).value());
            }
            for (ResourceLocation resourceLocation : (List)someBlacklist.getSecond()) {
                EntityBlacklist.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation));
            }
        }
    }

    protected static Pair<List<ResourceLocation>, List<ResourceLocation>> blacklistFromJson(JsonObject json) {
        return (Pair)BLACKLIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
    }
}

