/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.data.traits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class TraitDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Codec<TraitList> TRAIT_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(TraitList::requiredMod), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_types", new ArrayList()).forGetter(TraitList::entityTypeKeys), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entity_tags", new ArrayList()).forGetter(TraitList::entityTagKeys), (App)Codec.list(TraitRegistry.getTraitCodec()).fieldOf("traits").forGetter(TraitList::traitList)).apply((Applicative)instance, instance.stable(TraitList::new)));

    public TraitDataManager() {
        super(GSON, "walkers/traits");
    }

    protected void onApply(@NotNull Map<ResourceLocation, JsonElement> map) {
        TraitRegistry.clearAll();
        TraitRegistry.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            TraitList traitList = this.traitListFromJson(mapEntry.getValue().getAsJsonObject());
            if (traitList.isEmpty() || traitList.requiredMod() != null && !traitList.requiredMod().isBlank() && !PlatformData.isModLoaded((String)traitList.requiredMod())) continue;
            for (EntityType<LivingEntity> entityType : traitList.entityTypes()) {
                TraitRegistry.registerByType(entityType, traitList.traitList().stream().map(trait -> trait).toList());
            }
            if (!traitList.entityTypes().isEmpty()) {
                TraitDataManager.logRegistration(traitList.entityTypes(), traitList.traitList());
            }
            for (TagKey tagKey : traitList.entityTags()) {
                TraitRegistry.registerByTag(tagKey, traitList.traitList().stream().map(trait -> trait).toList());
            }
            if (traitList.entityTags().isEmpty()) continue;
            TraitDataManager.logRegistration(traitList.entityTags(), traitList.traitList());
        }
    }

    private static void logRegistration(Object key, @NotNull List<ShapeTrait<?>> traitList) {
        Walkers.LOGGER.warn("{}: {} registered for {}", new Object[]{TraitDataManager.class.getSimpleName(), traitList.stream().map(trait -> trait.getClass().getSimpleName()).toArray(String[]::new), key});
    }

    protected TraitList traitListFromJson(JsonObject json) {
        return (TraitList)TRAIT_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(msg -> {
            throw new JsonParseException(msg);
        });
    }

    public record TraitList(String requiredMod, List<ResourceLocation> entityTypeKeys, List<ResourceLocation> entityTagKeys, List<ShapeTrait<?>> traitList) {
        public TraitList(@NotNull List<EntityType<?>> entityTypeKeys, @NotNull List<TagKey<EntityType<?>>> entityTagKeys, List<ShapeTrait<?>> traitList, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(EntityType::getKey).toList(), entityTagKeys.stream().map(TagKey::location).toList(), traitList);
        }

        public List<EntityType<LivingEntity>> entityTypes() {
            return this.entityTypeKeys.stream().filter(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).containsKey(arg_0)).map(type -> (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(type).orElseThrow()).value()).toList();
        }

        public List<TagKey<EntityType<?>>> entityTags() {
            return this.entityTagKeys().stream().map(tag -> TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)tag)).toList();
        }

        public boolean isEmpty() {
            return this.entityTypeKeys().isEmpty() && this.entityTagKeys().isEmpty() || this.traitList().isEmpty();
        }
    }
}

